using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/30/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///Dialog box allowing users with Administrator/Supervisor privileges to maintain division details.
	///</summary>

	#endregion

	public class DlgMaintainDivision : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		/// <summary>
		/// VAMC Division to be maintained
		/// </summary>
		private BOL.Division _division;
		/// <summary>
		/// Is form still loading
		/// </summary>
		private bool _loadingDetails;

		private object[] _medicalDirectors;
		//private BOL.MedicalDirector _medicalDirector;
		private System.Data.DataTable _alertTypes;

        //CR3400 - variable to hold our starting values so we can update FrmVBECS if needed
	    private BOL.DivisionAlerts _startingDivisionAlerts;

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.TabControl tabOptions;
		private System.Windows.Forms.TabPage pageDivision;
		private System.Windows.Forms.TabPage pageTesting;
		private System.Windows.Forms.GroupBox grpDivisionInfo;
		private System.Windows.Forms.Panel pnlICCBBA;
		private System.Windows.Forms.TextBox txtICCBBARegNo;
		private System.Windows.Forms.Label lblICCBBARegNo;
		private System.Windows.Forms.Panel pnlServiceType;
		private System.Windows.Forms.Label lblServiceType;
		private System.Windows.Forms.GroupBox grpDivision;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.TextBox txtCode;
		private System.Windows.Forms.Label lblCode;
		private System.Windows.Forms.RadioButton rdoABSOnly;
		private System.Windows.Forms.RadioButton rdoABSDAT;
		private System.Windows.Forms.RadioButton rdoABSAutoControl;
		private System.Windows.Forms.Panel pnlXmatch;
		private System.Windows.Forms.RadioButton rdoXmatchEnabled;
		private System.Windows.Forms.RadioButton rdoXmatchDisabled;
		private System.Windows.Forms.GroupBox grpLine1;
		private System.Windows.Forms.GroupBox grpDivisionImage;
		private System.Windows.Forms.PictureBox picDivision;
		private System.Windows.Forms.GroupBox grpTestingImage;
		private System.Windows.Forms.PictureBox picTesting;
		private System.Windows.Forms.GroupBox grpTestingInfo;
		private System.Windows.Forms.Label lblXMatch;
		private System.Windows.Forms.GroupBox grpLine2;
		private System.Windows.Forms.Panel pnlAntibodyScreen;
		private System.Windows.Forms.Label lblAntibodyScreen;
		private System.Windows.Forms.GroupBox grpLine3;
		private System.Windows.Forms.Panel pnlMaxSpecimenExpiration;
		private System.Windows.Forms.Label lblMaxSpecimenExpiration;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updMaxSpecimenExpiration;
		private System.Windows.Forms.Label lblDays;
		private System.Windows.Forms.GroupBox grpLine4;
		private System.Windows.Forms.TabPage tabProductMods;
		private System.Windows.Forms.GroupBox grpProcedures;
		private System.Windows.Forms.Panel pnlProcedures;
		private System.Windows.Forms.CheckBox cbDeglycerolize;
		private System.Windows.Forms.CheckBox cbFreeze;
		private System.Windows.Forms.CheckBox cbRejuvenate;
		private System.Windows.Forms.CheckBox cbWash;
		private System.Windows.Forms.CheckBox cbVolumeReduce;
		private System.Windows.Forms.CheckBox cbLeukoreduce;
		private System.Windows.Forms.CheckBox cbIrradiate;
		private System.Windows.Forms.CheckBox cbSplit;
		private System.Windows.Forms.CheckBox cbPool;
		private System.Windows.Forms.CheckBox cbThaw;
		private System.Windows.Forms.Label lblEnabled;
		private System.Windows.Forms.Label lblProcedures;
		private System.Windows.Forms.CheckBox cbThawPool;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpAlertImage;
		private System.Windows.Forms.PictureBox picAlert;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.GroupBox grpMessageImage;
		private System.Windows.Forms.PictureBox picMessageImage;
		private System.Windows.Forms.GroupBox grpPrinterAlerts;
		private System.Windows.Forms.GroupBox grpIconAlerts;
		private System.Windows.Forms.CheckBox cbIconAlerts;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Panel pnlPrinterAlerts;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterAlertType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterAlertType;
		private System.Windows.Forms.Panel pnlIconAlerts;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbIconAlertType;
		private System.Windows.Forms.Label lblIconAlertType;
		private System.Windows.Forms.Label lblRefreshRate;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updRefreshRate;
		private System.Windows.Forms.Label lblSeconds;
		private System.Windows.Forms.Panel pnlPrinterOrdersNeeded;
		private System.Windows.Forms.Label lblPrinterHours;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updPrinterOrdersNeeded;
		private System.Windows.Forms.Label lblPrinterOrdersNeeded;
		private System.Windows.Forms.Panel pnlIconOrdersNeeded;
		private System.Windows.Forms.Label lblIconHours;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updIconOrdersNeeded;
		private System.Windows.Forms.Label lblIconOrdersNeeded;
		private System.Windows.Forms.TabPage pageOrderAlerts;
		private System.Windows.Forms.GroupBox grpOrderAlerts;
		private System.Windows.Forms.Label lblOrderAlerts;
		private System.Windows.Forms.TabPage pageLoginMessage;
		private System.Windows.Forms.GroupBox grpLoginMessage;
		private System.Windows.Forms.RichTextBox rtxtLoginMessage;
		private System.Windows.Forms.Label lblLoginMessage;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Panel pnlBloodBankMD;
		private System.Windows.Forms.Label lblBloodBankMD;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updThawCost;
		private System.Windows.Forms.Label lblThawDollar;
		private System.Windows.Forms.Label lblPoolDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updPoolCost;
		private System.Windows.Forms.Label lblThawPoolCryoDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updThawPoolCryoCost;
		private System.Windows.Forms.Label lblSplitDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updSplitDivideCost;
		private System.Windows.Forms.Label lblIrradiateDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updIrradiateCost;
		private System.Windows.Forms.Label lblLeukoReduceDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updLeukoReduceCost;
		private System.Windows.Forms.Label lblVolumeReduceDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updVolumeReduceCost;
		private System.Windows.Forms.Label lblWashDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updWashCost;
		private System.Windows.Forms.Label lblRejuvenateDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updRejuvenateCost;
		private System.Windows.Forms.Label lblFreezeDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updFreezeCost;
		private System.Windows.Forms.Label lblDeglycerolizeDollar;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updDeglycerolizeCost;
		private System.Windows.Forms.Label lblCost;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbMedicalDirector;
		private System.Windows.Forms.CheckBox cbPrinterAlerts;
		private System.Windows.Forms.TextBox txtServiceType;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Panel pnlReactivityPhase;
		private System.Windows.Forms.RadioButton rdoAllPhases;
		private System.Windows.Forms.RadioButton rdoAHGOnly;
		private System.ComponentModel.IContainer components = null;

		#endregion


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Maintain Division dialog constructor.
		/// Checks security level.
		/// Loads user's division.
		/// Populates dialog controls.
        /// Sets DialogResult to Abort on Instantiation if the record lock fails
		/// </summary>
		public DlgMaintainDivision()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC009MaintainVamcDivision;
			//
			this._division = new BOL.Division(LogonUser.LogonUserDivisionCode);
		    this._startingDivisionAlerts = (BOL.DivisionAlerts)this._division.DivisionAlerts.Clone();   //CR3400
			//
			this._loadingDetails = true;
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			if (!this.SetLocks(this._division.DivisionGuid)) 
			{
				this.DialogResult = System.Windows.Forms.DialogResult.Abort;
				return;
			}

			this._division.IsDirtyChanged += new System.EventHandler(CheckValid);
			this._division.Valid += new System.EventHandler(CheckValid);
			this._division.Invalid += new System.EventHandler(CheckValid);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			this._division.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);

			this._division.DivisionAlerts.IsDirtyChanged += new System.EventHandler(CheckValid);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			this._division.DivisionAlerts.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
			this._division.DivisionAlerts.Valid += new System.EventHandler(CheckValid);
			this._division.DivisionAlerts.Invalid += new System.EventHandler(CheckValid);
			//
			this._division.SetInitialBrokenRules(this.Name);
			this._division.DivisionAlerts.SetInitialBrokenRules(this.Name,"Alerts");
			//
			//force IsValid event to be fired now that event is handled
			this._division.IccbbaRegistrationNumber = this._division.IccbbaRegistrationNumber;
			this._division.MaximumSpecimenExpirationDays = this._division.MaximumSpecimenExpirationDays;
			//
			this.SetProductModifications();
			//
			this.PopulateForm();
			//
			//Remove combobox highlights
			this.cmbIconAlertType.SelectionLength = 0;
			this.cmbMedicalDirector.SelectionLength = 0;
			this.cmbPrinterAlertType.SelectionLength = 0;
			this.cmbPrinterName.SelectionLength = 0;
			//
			this._division.IsDirty = false;
			this._division.DivisionAlerts.IsDirty = false;
			//
			this._loadingDetails = false;

			this.IsDirty=false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgMaintainDivision));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtICCBBARegNo = new System.Windows.Forms.TextBox();
			this.txtName = new System.Windows.Forms.TextBox();
			this.txtCode = new System.Windows.Forms.TextBox();
			this.rdoABSOnly = new System.Windows.Forms.RadioButton();
			this.rdoABSDAT = new System.Windows.Forms.RadioButton();
			this.rdoABSAutoControl = new System.Windows.Forms.RadioButton();
			this.rdoXmatchEnabled = new System.Windows.Forms.RadioButton();
			this.rdoXmatchDisabled = new System.Windows.Forms.RadioButton();
			this.tabOptions = new System.Windows.Forms.TabControl();
			this.pageDivision = new System.Windows.Forms.TabPage();
			this.grpDivisionInfo = new System.Windows.Forms.GroupBox();
			this.pnlBloodBankMD = new System.Windows.Forms.Panel();
			this.cmbMedicalDirector = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblBloodBankMD = new System.Windows.Forms.Label();
			this.pnlMaxSpecimenExpiration = new System.Windows.Forms.Panel();
			this.lblDays = new System.Windows.Forms.Label();
			this.updMaxSpecimenExpiration = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblMaxSpecimenExpiration = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pnlICCBBA = new System.Windows.Forms.Panel();
			this.lblICCBBARegNo = new System.Windows.Forms.Label();
			this.grpLine1 = new System.Windows.Forms.GroupBox();
			this.grpDivisionImage = new System.Windows.Forms.GroupBox();
			this.picDivision = new System.Windows.Forms.PictureBox();
			this.tabProductMods = new System.Windows.Forms.TabPage();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpProcedures = new System.Windows.Forms.GroupBox();
			this.pnlProcedures = new System.Windows.Forms.Panel();
			this.lblDeglycerolizeDollar = new System.Windows.Forms.Label();
			this.updDeglycerolizeCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblFreezeDollar = new System.Windows.Forms.Label();
			this.updFreezeCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblRejuvenateDollar = new System.Windows.Forms.Label();
			this.updRejuvenateCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblWashDollar = new System.Windows.Forms.Label();
			this.updWashCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblVolumeReduceDollar = new System.Windows.Forms.Label();
			this.updVolumeReduceCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblLeukoReduceDollar = new System.Windows.Forms.Label();
			this.updLeukoReduceCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblIrradiateDollar = new System.Windows.Forms.Label();
			this.updIrradiateCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblSplitDollar = new System.Windows.Forms.Label();
			this.updSplitDivideCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblThawPoolCryoDollar = new System.Windows.Forms.Label();
			this.updThawPoolCryoCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblPoolDollar = new System.Windows.Forms.Label();
			this.updPoolCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblThawDollar = new System.Windows.Forms.Label();
			this.updThawCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblCost = new System.Windows.Forms.Label();
			this.cbDeglycerolize = new System.Windows.Forms.CheckBox();
			this.cbFreeze = new System.Windows.Forms.CheckBox();
			this.cbRejuvenate = new System.Windows.Forms.CheckBox();
			this.cbWash = new System.Windows.Forms.CheckBox();
			this.cbVolumeReduce = new System.Windows.Forms.CheckBox();
			this.cbLeukoreduce = new System.Windows.Forms.CheckBox();
			this.cbIrradiate = new System.Windows.Forms.CheckBox();
			this.cbSplit = new System.Windows.Forms.CheckBox();
			this.cbPool = new System.Windows.Forms.CheckBox();
			this.cbThaw = new System.Windows.Forms.CheckBox();
			this.lblEnabled = new System.Windows.Forms.Label();
			this.lblProcedures = new System.Windows.Forms.Label();
			this.cbThawPool = new System.Windows.Forms.CheckBox();
			this.pageOrderAlerts = new System.Windows.Forms.TabPage();
			this.grpOrderAlerts = new System.Windows.Forms.GroupBox();
			this.lblOrderAlerts = new System.Windows.Forms.Label();
			this.grpIconAlerts = new System.Windows.Forms.GroupBox();
			this.pnlIconAlerts = new System.Windows.Forms.Panel();
			this.pnlIconOrdersNeeded = new System.Windows.Forms.Panel();
			this.lblIconHours = new System.Windows.Forms.Label();
			this.updIconOrdersNeeded = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblIconOrdersNeeded = new System.Windows.Forms.Label();
			this.lblSeconds = new System.Windows.Forms.Label();
			this.updRefreshRate = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.cmbIconAlertType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblIconAlertType = new System.Windows.Forms.Label();
			this.lblRefreshRate = new System.Windows.Forms.Label();
			this.cbIconAlerts = new System.Windows.Forms.CheckBox();
			this.grpPrinterAlerts = new System.Windows.Forms.GroupBox();
			this.cbPrinterAlerts = new System.Windows.Forms.CheckBox();
			this.pnlPrinterAlerts = new System.Windows.Forms.Panel();
			this.pnlPrinterOrdersNeeded = new System.Windows.Forms.Panel();
			this.lblPrinterHours = new System.Windows.Forms.Label();
			this.updPrinterOrdersNeeded = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblPrinterOrdersNeeded = new System.Windows.Forms.Label();
			this.cmbPrinterAlertType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterAlertType = new System.Windows.Forms.Label();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.grpAlertImage = new System.Windows.Forms.GroupBox();
			this.picAlert = new System.Windows.Forms.PictureBox();
			this.pageTesting = new System.Windows.Forms.TabPage();
			this.grpTestingImage = new System.Windows.Forms.GroupBox();
			this.picTesting = new System.Windows.Forms.PictureBox();
			this.grpTestingInfo = new System.Windows.Forms.GroupBox();
			this.pnlReactivityPhase = new System.Windows.Forms.Panel();
			this.rdoAllPhases = new System.Windows.Forms.RadioButton();
			this.rdoAHGOnly = new System.Windows.Forms.RadioButton();
			this.label1 = new System.Windows.Forms.Label();
			this.pnlServiceType = new System.Windows.Forms.Panel();
			this.lblServiceType = new System.Windows.Forms.Label();
			this.txtServiceType = new System.Windows.Forms.TextBox();
			this.grpLine4 = new System.Windows.Forms.GroupBox();
			this.pnlXmatch = new System.Windows.Forms.Panel();
			this.lblXMatch = new System.Windows.Forms.Label();
			this.grpLine2 = new System.Windows.Forms.GroupBox();
			this.pnlAntibodyScreen = new System.Windows.Forms.Panel();
			this.lblAntibodyScreen = new System.Windows.Forms.Label();
			this.grpLine3 = new System.Windows.Forms.GroupBox();
			this.pageLoginMessage = new System.Windows.Forms.TabPage();
			this.grpLoginMessage = new System.Windows.Forms.GroupBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.rtxtLoginMessage = new System.Windows.Forms.RichTextBox();
			this.lblLoginMessage = new System.Windows.Forms.Label();
			this.grpMessageImage = new System.Windows.Forms.GroupBox();
			this.picMessageImage = new System.Windows.Forms.PictureBox();
			this.grpDivision = new System.Windows.Forms.GroupBox();
			this.lblName = new System.Windows.Forms.Label();
			this.lblCode = new System.Windows.Forms.Label();
			this.tabOptions.SuspendLayout();
			this.pageDivision.SuspendLayout();
			this.grpDivisionInfo.SuspendLayout();
			this.pnlBloodBankMD.SuspendLayout();
			this.pnlMaxSpecimenExpiration.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updMaxSpecimenExpiration)).BeginInit();
			this.pnlICCBBA.SuspendLayout();
			this.grpDivisionImage.SuspendLayout();
			this.tabProductMods.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.grpProcedures.SuspendLayout();
			this.pnlProcedures.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updDeglycerolizeCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updFreezeCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updRejuvenateCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updWashCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updVolumeReduceCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updLeukoReduceCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updIrradiateCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updSplitDivideCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updThawPoolCryoCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updPoolCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updThawCost)).BeginInit();
			this.pageOrderAlerts.SuspendLayout();
			this.grpOrderAlerts.SuspendLayout();
			this.grpIconAlerts.SuspendLayout();
			this.pnlIconAlerts.SuspendLayout();
			this.pnlIconOrdersNeeded.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updIconOrdersNeeded)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updRefreshRate)).BeginInit();
			this.grpPrinterAlerts.SuspendLayout();
			this.pnlPrinterAlerts.SuspendLayout();
			this.pnlPrinterOrdersNeeded.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updPrinterOrdersNeeded)).BeginInit();
			this.grpAlertImage.SuspendLayout();
			this.pageTesting.SuspendLayout();
			this.grpTestingImage.SuspendLayout();
			this.grpTestingInfo.SuspendLayout();
			this.pnlReactivityPhase.SuspendLayout();
			this.pnlServiceType.SuspendLayout();
			this.pnlXmatch.SuspendLayout();
			this.pnlAntibodyScreen.SuspendLayout();
			this.pageLoginMessage.SuspendLayout();
			this.grpLoginMessage.SuspendLayout();
			this.grpMessageImage.SuspendLayout();
			this.grpDivision.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(452, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "System Configuration";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 417);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(372, 399);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 41;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(292, 399);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 40;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// txtICCBBARegNo
			// 
			this.txtICCBBARegNo.AccessibleDescription = "I C C B B A Registration Number";
			this.txtICCBBARegNo.AccessibleName = "I C C B B A Registration Number";
			this.txtICCBBARegNo.Location = new System.Drawing.Point(136, 4);
			this.txtICCBBARegNo.MaxLength = 5;
			this.txtICCBBARegNo.Name = "txtICCBBARegNo";
			this.txtICCBBARegNo.Size = new System.Drawing.Size(72, 20);
			this.txtICCBBARegNo.TabIndex = 3;
			this.txtICCBBARegNo.Text = "";
			this.txtICCBBARegNo.TextChanged += new System.EventHandler(this.txtICCBBARegNo_TextChanged);
			this.txtICCBBARegNo.Leave += new System.EventHandler(this.txtICCBBARegNo_Leave);
			// 
			// txtName
			// 
			this.txtName.AccessibleDescription = "Division Name";
			this.txtName.AccessibleName = "Division Name";
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(256, 10);
			this.txtName.MaxLength = 5;
			this.txtName.Name = "txtName";
			this.txtName.ReadOnly = true;
			this.txtName.Size = new System.Drawing.Size(178, 20);
			this.txtName.TabIndex = 2;
			this.txtName.Text = "";
			this.ttToolTip.SetToolTip(this.txtName, "VAMC division name");
			// 
			// txtCode
			// 
			this.txtCode.AccessibleDescription = "Division Code";
			this.txtCode.AccessibleName = "Division Code";
			this.txtCode.Location = new System.Drawing.Point(88, 10);
			this.txtCode.MaxLength = 5;
			this.txtCode.Name = "txtCode";
			this.txtCode.ReadOnly = true;
			this.txtCode.Size = new System.Drawing.Size(72, 20);
			this.txtCode.TabIndex = 1;
			this.txtCode.Text = "";
			this.ttToolTip.SetToolTip(this.txtCode, "VAMC division code");
			// 
			// rdoABSOnly
			// 
			this.rdoABSOnly.AccessibleDescription = "Antibody Screen Only";
			this.rdoABSOnly.AccessibleName = "Antibody Screen Only";
			this.rdoABSOnly.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoABSOnly.Checked = true;
			this.rdoABSOnly.Location = new System.Drawing.Point(116, 4);
			this.rdoABSOnly.Name = "rdoABSOnly";
			this.rdoABSOnly.Size = new System.Drawing.Size(246, 20);
			this.rdoABSOnly.TabIndex = 1;
			this.rdoABSOnly.TabStop = true;
			this.rdoABSOnly.Text = "Antibody &Screen Only";
			this.rdoABSOnly.CheckedChanged += new System.EventHandler(this.rdoABSOnly_CheckedChanged);
			// 
			// rdoABSDAT
			// 
			this.rdoABSDAT.AccessibleDescription = "Antibody Screen with D A T";
			this.rdoABSDAT.AccessibleName = "Antibody Screen with D A T";
			this.rdoABSDAT.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoABSDAT.Location = new System.Drawing.Point(116, 24);
			this.rdoABSDAT.Name = "rdoABSDAT";
			this.rdoABSDAT.Size = new System.Drawing.Size(246, 20);
			this.rdoABSDAT.TabIndex = 2;
			this.rdoABSDAT.Text = "Antibody Screen with &DAT";
			this.rdoABSDAT.CheckedChanged += new System.EventHandler(this.rdoABSDAT_CheckedChanged);
			// 
			// rdoABSAutoControl
			// 
			this.rdoABSAutoControl.AccessibleDescription = "Antibody Screen with Auto Control";
			this.rdoABSAutoControl.AccessibleName = "Antibody Screen with Auto Control";
			this.rdoABSAutoControl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoABSAutoControl.Location = new System.Drawing.Point(116, 44);
			this.rdoABSAutoControl.Name = "rdoABSAutoControl";
			this.rdoABSAutoControl.Size = new System.Drawing.Size(250, 20);
			this.rdoABSAutoControl.TabIndex = 3;
			this.rdoABSAutoControl.Text = "Antibody Screen with &Autocontrol";
			this.rdoABSAutoControl.CheckedChanged += new System.EventHandler(this.rdoABSAutoControl_CheckedChanged);
			// 
			// rdoXmatchEnabled
			// 
			this.rdoXmatchEnabled.AccessibleDescription = "Electronic Crossmatch Enabled";
			this.rdoXmatchEnabled.AccessibleName = "Electronic Crossmatch Enabled";
			this.rdoXmatchEnabled.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoXmatchEnabled.Location = new System.Drawing.Point(116, 24);
			this.rdoXmatchEnabled.Name = "rdoXmatchEnabled";
			this.rdoXmatchEnabled.Size = new System.Drawing.Size(246, 20);
			this.rdoXmatchEnabled.TabIndex = 2;
			this.rdoXmatchEnabled.Text = "&Enabled";
			this.rdoXmatchEnabled.CheckedChanged += new System.EventHandler(this.ElectronicCrossmatchIndicatorChanged);
			// 
			// rdoXmatchDisabled
			// 
			this.rdoXmatchDisabled.AccessibleDescription = "Electronic Crossmatch Disabled";
			this.rdoXmatchDisabled.AccessibleName = "Electronic Crossmatch Disabled";
			this.rdoXmatchDisabled.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoXmatchDisabled.Checked = true;
			this.rdoXmatchDisabled.Location = new System.Drawing.Point(116, 4);
			this.rdoXmatchDisabled.Name = "rdoXmatchDisabled";
			this.rdoXmatchDisabled.Size = new System.Drawing.Size(246, 20);
			this.rdoXmatchDisabled.TabIndex = 1;
			this.rdoXmatchDisabled.TabStop = true;
			this.rdoXmatchDisabled.Text = "Disa&bled";
			this.rdoXmatchDisabled.CheckedChanged += new System.EventHandler(this.ElectronicCrossmatchIndicatorChanged);
			// 
			// tabOptions
			// 
			this.tabOptions.AccessibleDescription = "System Configuration";
			this.tabOptions.AccessibleName = "System Configuration";
			this.tabOptions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabOptions.Controls.Add(this.pageDivision);
			this.tabOptions.Controls.Add(this.tabProductMods);
			this.tabOptions.Controls.Add(this.pageOrderAlerts);
			this.tabOptions.Controls.Add(this.pageTesting);
			this.tabOptions.Controls.Add(this.pageLoginMessage);
			this.tabOptions.Location = new System.Drawing.Point(4, 64);
			this.tabOptions.Multiline = true;
			this.tabOptions.Name = "tabOptions";
			this.tabOptions.SelectedIndex = 0;
			this.tabOptions.Size = new System.Drawing.Size(444, 332);
			this.tabOptions.SizeMode = System.Windows.Forms.TabSizeMode.FillToRight;
			this.tabOptions.TabIndex = 3;
			this.tabOptions.SelectedIndexChanged += new System.EventHandler(this.tabOptions_SelectedIndexChanged);
			// 
			// pageDivision
			// 
			this.pageDivision.Controls.Add(this.grpDivisionInfo);
			this.pageDivision.Controls.Add(this.grpDivisionImage);
			this.pageDivision.Location = new System.Drawing.Point(4, 42);
			this.pageDivision.Name = "pageDivision";
			this.pageDivision.Size = new System.Drawing.Size(436, 286);
			this.pageDivision.TabIndex = 0;
			this.pageDivision.Text = "Configure Division";
			// 
			// grpDivisionInfo
			// 
			this.grpDivisionInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivisionInfo.Controls.Add(this.pnlBloodBankMD);
			this.grpDivisionInfo.Controls.Add(this.pnlMaxSpecimenExpiration);
			this.grpDivisionInfo.Controls.Add(this.groupBox2);
			this.grpDivisionInfo.Controls.Add(this.pnlICCBBA);
			this.grpDivisionInfo.Controls.Add(this.grpLine1);
			this.grpDivisionInfo.Location = new System.Drawing.Point(56, 0);
			this.grpDivisionInfo.Name = "grpDivisionInfo";
			this.grpDivisionInfo.Size = new System.Drawing.Size(380, 286);
			this.grpDivisionInfo.TabIndex = 0;
			this.grpDivisionInfo.TabStop = false;
			// 
			// pnlBloodBankMD
			// 
			this.pnlBloodBankMD.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlBloodBankMD.Controls.Add(this.cmbMedicalDirector);
			this.pnlBloodBankMD.Controls.Add(this.lblBloodBankMD);
			this.pnlBloodBankMD.Location = new System.Drawing.Point(4, 40);
			this.pnlBloodBankMD.Name = "pnlBloodBankMD";
			this.pnlBloodBankMD.Size = new System.Drawing.Size(370, 28);
			this.pnlBloodBankMD.TabIndex = 2;
			// 
			// cmbMedicalDirector
			// 
			this.cmbMedicalDirector.AccessibleDescription = "Medical Director\'s Name";
			this.cmbMedicalDirector.AccessibleName = "Medical Director\'s Name";
			this.cmbMedicalDirector.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbMedicalDirector.Interval = 500;
			this.cmbMedicalDirector.Location = new System.Drawing.Point(136, 4);
			this.cmbMedicalDirector.LookupEnabled = false;
			this.cmbMedicalDirector.MaxLength = 30;
			this.cmbMedicalDirector.Name = "cmbMedicalDirector";
			this.cmbMedicalDirector.Size = new System.Drawing.Size(222, 22);
			this.cmbMedicalDirector.TabIndex = 1;
			this.cmbMedicalDirector.TextChanged += new System.EventHandler(this.cmbMedicalDirector_TextChanged);
			// 
			// lblBloodBankMD
			// 
			this.lblBloodBankMD.Location = new System.Drawing.Point(0, 4);
			this.lblBloodBankMD.Name = "lblBloodBankMD";
			this.lblBloodBankMD.Size = new System.Drawing.Size(132, 20);
			this.lblBloodBankMD.TabIndex = 0;
			this.lblBloodBankMD.Text = "Medical Director\'s Name*";
			this.lblBloodBankMD.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlMaxSpecimenExpiration
			// 
			this.pnlMaxSpecimenExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlMaxSpecimenExpiration.Controls.Add(this.lblDays);
			this.pnlMaxSpecimenExpiration.Controls.Add(this.updMaxSpecimenExpiration);
			this.pnlMaxSpecimenExpiration.Controls.Add(this.lblMaxSpecimenExpiration);
			this.pnlMaxSpecimenExpiration.Location = new System.Drawing.Point(4, 72);
			this.pnlMaxSpecimenExpiration.Name = "pnlMaxSpecimenExpiration";
			this.pnlMaxSpecimenExpiration.Size = new System.Drawing.Size(370, 28);
			this.pnlMaxSpecimenExpiration.TabIndex = 4;
			// 
			// lblDays
			// 
			this.lblDays.Location = new System.Drawing.Point(212, 4);
			this.lblDays.Name = "lblDays";
			this.lblDays.Size = new System.Drawing.Size(40, 20);
			this.lblDays.TabIndex = 2;
			this.lblDays.Text = "Days";
			this.lblDays.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updMaxSpecimenExpiration
			// 
			this.updMaxSpecimenExpiration.AccessibleDescription = "Maximum Specimen Expiration Days";
			this.updMaxSpecimenExpiration.AccessibleName = "Maximum Specimen Expiration Days";
			this.updMaxSpecimenExpiration.Location = new System.Drawing.Point(136, 4);
			this.updMaxSpecimenExpiration.Maximum = new System.Decimal(new int[] {
																					 93,
																					 0,
																					 0,
																					 0});
			this.updMaxSpecimenExpiration.Minimum = new System.Decimal(new int[] {
																					 3,
																					 0,
																					 0,
																					 0});
			this.updMaxSpecimenExpiration.Name = "updMaxSpecimenExpiration";
			this.updMaxSpecimenExpiration.Size = new System.Drawing.Size(76, 20);
			this.updMaxSpecimenExpiration.TabIndex = 1;
			this.updMaxSpecimenExpiration.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updMaxSpecimenExpiration.Value = new System.Decimal(new int[] {
																				   3,
																				   0,
																				   0,
																				   0});
			this.updMaxSpecimenExpiration.TextChanged += new System.EventHandler(this.updMaxSpecimenExpiration_TextChanged);
			this.updMaxSpecimenExpiration.Leave += new System.EventHandler(this.updMaxSpecimenExpiration_Leave);
			this.updMaxSpecimenExpiration.ValueChanged += new System.EventHandler(this.updMaxSpecimenExpiration_TextChanged);
			// 
			// lblMaxSpecimenExpiration
			// 
			this.lblMaxSpecimenExpiration.Location = new System.Drawing.Point(0, 4);
			this.lblMaxSpecimenExpiration.Name = "lblMaxSpecimenExpiration";
			this.lblMaxSpecimenExpiration.Size = new System.Drawing.Size(140, 20);
			this.lblMaxSpecimenExpiration.TabIndex = 0;
			this.lblMaxSpecimenExpiration.Text = "Max. Specimen Expiration*";
			this.lblMaxSpecimenExpiration.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Location = new System.Drawing.Point(4, 64);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(370, 7);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			// 
			// pnlICCBBA
			// 
			this.pnlICCBBA.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlICCBBA.Controls.Add(this.txtICCBBARegNo);
			this.pnlICCBBA.Controls.Add(this.lblICCBBARegNo);
			this.pnlICCBBA.Location = new System.Drawing.Point(4, 8);
			this.pnlICCBBA.Name = "pnlICCBBA";
			this.pnlICCBBA.Size = new System.Drawing.Size(370, 28);
			this.pnlICCBBA.TabIndex = 0;
			// 
			// lblICCBBARegNo
			// 
			this.lblICCBBARegNo.Location = new System.Drawing.Point(0, 4);
			this.lblICCBBARegNo.Name = "lblICCBBARegNo";
			this.lblICCBBARegNo.Size = new System.Drawing.Size(136, 20);
			this.lblICCBBARegNo.TabIndex = 0;
			this.lblICCBBARegNo.Text = "ICCBBA Registration No.*";
			this.lblICCBBARegNo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpLine1
			// 
			this.grpLine1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLine1.Location = new System.Drawing.Point(4, 32);
			this.grpLine1.Name = "grpLine1";
			this.grpLine1.Size = new System.Drawing.Size(370, 7);
			this.grpLine1.TabIndex = 1;
			this.grpLine1.TabStop = false;
			// 
			// grpDivisionImage
			// 
			this.grpDivisionImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpDivisionImage.Controls.Add(this.picDivision);
			this.grpDivisionImage.Location = new System.Drawing.Point(0, 0);
			this.grpDivisionImage.Name = "grpDivisionImage";
			this.grpDivisionImage.Size = new System.Drawing.Size(52, 286);
			this.grpDivisionImage.TabIndex = 1;
			this.grpDivisionImage.TabStop = false;
			// 
			// picDivision
			// 
			this.picDivision.Image = ((System.Drawing.Image)(resources.GetObject("picDivision.Image")));
			this.picDivision.Location = new System.Drawing.Point(4, 12);
			this.picDivision.Name = "picDivision";
			this.picDivision.Size = new System.Drawing.Size(45, 45);
			this.picDivision.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picDivision.TabIndex = 0;
			this.picDivision.TabStop = false;
			// 
			// tabProductMods
			// 
			this.tabProductMods.Controls.Add(this.groupBox1);
			this.tabProductMods.Controls.Add(this.grpProcedures);
			this.tabProductMods.Location = new System.Drawing.Point(4, 42);
			this.tabProductMods.Name = "tabProductMods";
			this.tabProductMods.Size = new System.Drawing.Size(436, 286);
			this.tabProductMods.TabIndex = 2;
			this.tabProductMods.Text = "Product Modifications";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.pictureBox1);
			this.groupBox1.Location = new System.Drawing.Point(0, 0);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(52, 286);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// grpProcedures
			// 
			this.grpProcedures.AccessibleDescription = "Product Modifications";
			this.grpProcedures.AccessibleName = "Product Modifications";
			this.grpProcedures.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpProcedures.Controls.Add(this.pnlProcedures);
			this.grpProcedures.Location = new System.Drawing.Point(56, 0);
			this.grpProcedures.Name = "grpProcedures";
			this.grpProcedures.Size = new System.Drawing.Size(380, 286);
			this.grpProcedures.TabIndex = 0;
			this.grpProcedures.TabStop = false;
			// 
			// pnlProcedures
			// 
			this.pnlProcedures.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlProcedures.BackColor = System.Drawing.SystemColors.Window;
			this.pnlProcedures.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.pnlProcedures.Controls.Add(this.lblDeglycerolizeDollar);
			this.pnlProcedures.Controls.Add(this.updDeglycerolizeCost);
			this.pnlProcedures.Controls.Add(this.lblFreezeDollar);
			this.pnlProcedures.Controls.Add(this.updFreezeCost);
			this.pnlProcedures.Controls.Add(this.lblRejuvenateDollar);
			this.pnlProcedures.Controls.Add(this.updRejuvenateCost);
			this.pnlProcedures.Controls.Add(this.lblWashDollar);
			this.pnlProcedures.Controls.Add(this.updWashCost);
			this.pnlProcedures.Controls.Add(this.lblVolumeReduceDollar);
			this.pnlProcedures.Controls.Add(this.updVolumeReduceCost);
			this.pnlProcedures.Controls.Add(this.lblLeukoReduceDollar);
			this.pnlProcedures.Controls.Add(this.updLeukoReduceCost);
			this.pnlProcedures.Controls.Add(this.lblIrradiateDollar);
			this.pnlProcedures.Controls.Add(this.updIrradiateCost);
			this.pnlProcedures.Controls.Add(this.lblSplitDollar);
			this.pnlProcedures.Controls.Add(this.updSplitDivideCost);
			this.pnlProcedures.Controls.Add(this.lblThawPoolCryoDollar);
			this.pnlProcedures.Controls.Add(this.updThawPoolCryoCost);
			this.pnlProcedures.Controls.Add(this.lblPoolDollar);
			this.pnlProcedures.Controls.Add(this.updPoolCost);
			this.pnlProcedures.Controls.Add(this.lblThawDollar);
			this.pnlProcedures.Controls.Add(this.updThawCost);
			this.pnlProcedures.Controls.Add(this.lblCost);
			this.pnlProcedures.Controls.Add(this.cbDeglycerolize);
			this.pnlProcedures.Controls.Add(this.cbFreeze);
			this.pnlProcedures.Controls.Add(this.cbRejuvenate);
			this.pnlProcedures.Controls.Add(this.cbWash);
			this.pnlProcedures.Controls.Add(this.cbVolumeReduce);
			this.pnlProcedures.Controls.Add(this.cbLeukoreduce);
			this.pnlProcedures.Controls.Add(this.cbIrradiate);
			this.pnlProcedures.Controls.Add(this.cbSplit);
			this.pnlProcedures.Controls.Add(this.cbPool);
			this.pnlProcedures.Controls.Add(this.cbThaw);
			this.pnlProcedures.Controls.Add(this.lblEnabled);
			this.pnlProcedures.Controls.Add(this.lblProcedures);
			this.pnlProcedures.Controls.Add(this.cbThawPool);
			this.pnlProcedures.Location = new System.Drawing.Point(8, 12);
			this.pnlProcedures.Name = "pnlProcedures";
			this.pnlProcedures.Size = new System.Drawing.Size(364, 268);
			this.pnlProcedures.TabIndex = 0;
			// 
			// lblDeglycerolizeDollar
			// 
			this.lblDeglycerolizeDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblDeglycerolizeDollar.Location = new System.Drawing.Point(268, 242);
			this.lblDeglycerolizeDollar.Name = "lblDeglycerolizeDollar";
			this.lblDeglycerolizeDollar.Size = new System.Drawing.Size(12, 20);
			this.lblDeglycerolizeDollar.TabIndex = 34;
			this.lblDeglycerolizeDollar.Text = "$";
			this.lblDeglycerolizeDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updDeglycerolizeCost
			// 
			this.updDeglycerolizeCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updDeglycerolizeCost.DecimalPlaces = 2;
			this.updDeglycerolizeCost.Enabled = false;
			this.updDeglycerolizeCost.Location = new System.Drawing.Point(280, 242);
			this.updDeglycerolizeCost.Maximum = new System.Decimal(new int[] {
																				 999999,
																				 0,
																				 0,
																				 131072});
			this.updDeglycerolizeCost.Name = "updDeglycerolizeCost";
			this.updDeglycerolizeCost.Size = new System.Drawing.Size(64, 20);
			this.updDeglycerolizeCost.TabIndex = 35;
			this.updDeglycerolizeCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updDeglycerolizeCost.Value = new System.Decimal(new int[] {
																			   0,
																			   0,
																			   0,
																			   0});
			this.updDeglycerolizeCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updDeglycerolizeCost.Leave += new System.EventHandler(this.CostLeave);
			this.updDeglycerolizeCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblFreezeDollar
			// 
			this.lblFreezeDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblFreezeDollar.Location = new System.Drawing.Point(268, 220);
			this.lblFreezeDollar.Name = "lblFreezeDollar";
			this.lblFreezeDollar.Size = new System.Drawing.Size(12, 20);
			this.lblFreezeDollar.TabIndex = 31;
			this.lblFreezeDollar.Text = "$";
			this.lblFreezeDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updFreezeCost
			// 
			this.updFreezeCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updFreezeCost.DecimalPlaces = 2;
			this.updFreezeCost.Enabled = false;
			this.updFreezeCost.Location = new System.Drawing.Point(280, 220);
			this.updFreezeCost.Maximum = new System.Decimal(new int[] {
																		  999999,
																		  0,
																		  0,
																		  131072});
			this.updFreezeCost.Name = "updFreezeCost";
			this.updFreezeCost.Size = new System.Drawing.Size(64, 20);
			this.updFreezeCost.TabIndex = 32;
			this.updFreezeCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updFreezeCost.Value = new System.Decimal(new int[] {
																		0,
																		0,
																		0,
																		0});
			this.updFreezeCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updFreezeCost.Leave += new System.EventHandler(this.CostLeave);
			this.updFreezeCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblRejuvenateDollar
			// 
			this.lblRejuvenateDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblRejuvenateDollar.Location = new System.Drawing.Point(268, 198);
			this.lblRejuvenateDollar.Name = "lblRejuvenateDollar";
			this.lblRejuvenateDollar.Size = new System.Drawing.Size(12, 20);
			this.lblRejuvenateDollar.TabIndex = 28;
			this.lblRejuvenateDollar.Text = "$";
			this.lblRejuvenateDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updRejuvenateCost
			// 
			this.updRejuvenateCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updRejuvenateCost.DecimalPlaces = 2;
			this.updRejuvenateCost.Enabled = false;
			this.updRejuvenateCost.Location = new System.Drawing.Point(280, 198);
			this.updRejuvenateCost.Maximum = new System.Decimal(new int[] {
																			  999999,
																			  0,
																			  0,
																			  131072});
			this.updRejuvenateCost.Name = "updRejuvenateCost";
			this.updRejuvenateCost.Size = new System.Drawing.Size(64, 20);
			this.updRejuvenateCost.TabIndex = 29;
			this.updRejuvenateCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updRejuvenateCost.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.updRejuvenateCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updRejuvenateCost.Leave += new System.EventHandler(this.CostLeave);
			this.updRejuvenateCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblWashDollar
			// 
			this.lblWashDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblWashDollar.Location = new System.Drawing.Point(268, 176);
			this.lblWashDollar.Name = "lblWashDollar";
			this.lblWashDollar.Size = new System.Drawing.Size(12, 20);
			this.lblWashDollar.TabIndex = 25;
			this.lblWashDollar.Text = "$";
			this.lblWashDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updWashCost
			// 
			this.updWashCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updWashCost.DecimalPlaces = 2;
			this.updWashCost.Enabled = false;
			this.updWashCost.Location = new System.Drawing.Point(280, 176);
			this.updWashCost.Maximum = new System.Decimal(new int[] {
																		999999,
																		0,
																		0,
																		131072});
			this.updWashCost.Name = "updWashCost";
			this.updWashCost.Size = new System.Drawing.Size(64, 20);
			this.updWashCost.TabIndex = 26;
			this.updWashCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updWashCost.Value = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.updWashCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updWashCost.Leave += new System.EventHandler(this.CostLeave);
			this.updWashCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblVolumeReduceDollar
			// 
			this.lblVolumeReduceDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblVolumeReduceDollar.Location = new System.Drawing.Point(268, 154);
			this.lblVolumeReduceDollar.Name = "lblVolumeReduceDollar";
			this.lblVolumeReduceDollar.Size = new System.Drawing.Size(12, 20);
			this.lblVolumeReduceDollar.TabIndex = 22;
			this.lblVolumeReduceDollar.Text = "$";
			this.lblVolumeReduceDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updVolumeReduceCost
			// 
			this.updVolumeReduceCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updVolumeReduceCost.DecimalPlaces = 2;
			this.updVolumeReduceCost.Enabled = false;
			this.updVolumeReduceCost.Location = new System.Drawing.Point(280, 154);
			this.updVolumeReduceCost.Maximum = new System.Decimal(new int[] {
																				999999,
																				0,
																				0,
																				131072});
			this.updVolumeReduceCost.Name = "updVolumeReduceCost";
			this.updVolumeReduceCost.Size = new System.Drawing.Size(64, 20);
			this.updVolumeReduceCost.TabIndex = 23;
			this.updVolumeReduceCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updVolumeReduceCost.Value = new System.Decimal(new int[] {
																			  0,
																			  0,
																			  0,
																			  0});
			this.updVolumeReduceCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updVolumeReduceCost.Leave += new System.EventHandler(this.CostLeave);
			this.updVolumeReduceCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblLeukoReduceDollar
			// 
			this.lblLeukoReduceDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblLeukoReduceDollar.Location = new System.Drawing.Point(268, 132);
			this.lblLeukoReduceDollar.Name = "lblLeukoReduceDollar";
			this.lblLeukoReduceDollar.Size = new System.Drawing.Size(12, 20);
			this.lblLeukoReduceDollar.TabIndex = 19;
			this.lblLeukoReduceDollar.Text = "$";
			this.lblLeukoReduceDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updLeukoReduceCost
			// 
			this.updLeukoReduceCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updLeukoReduceCost.DecimalPlaces = 2;
			this.updLeukoReduceCost.Enabled = false;
			this.updLeukoReduceCost.Location = new System.Drawing.Point(280, 132);
			this.updLeukoReduceCost.Maximum = new System.Decimal(new int[] {
																			   999999,
																			   0,
																			   0,
																			   131072});
			this.updLeukoReduceCost.Name = "updLeukoReduceCost";
			this.updLeukoReduceCost.Size = new System.Drawing.Size(64, 20);
			this.updLeukoReduceCost.TabIndex = 20;
			this.updLeukoReduceCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updLeukoReduceCost.Value = new System.Decimal(new int[] {
																			 0,
																			 0,
																			 0,
																			 0});
			this.updLeukoReduceCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updLeukoReduceCost.Leave += new System.EventHandler(this.CostLeave);
			this.updLeukoReduceCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblIrradiateDollar
			// 
			this.lblIrradiateDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblIrradiateDollar.Location = new System.Drawing.Point(268, 110);
			this.lblIrradiateDollar.Name = "lblIrradiateDollar";
			this.lblIrradiateDollar.Size = new System.Drawing.Size(12, 20);
			this.lblIrradiateDollar.TabIndex = 16;
			this.lblIrradiateDollar.Text = "$";
			this.lblIrradiateDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updIrradiateCost
			// 
			this.updIrradiateCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updIrradiateCost.DecimalPlaces = 2;
			this.updIrradiateCost.Enabled = false;
			this.updIrradiateCost.Location = new System.Drawing.Point(280, 110);
			this.updIrradiateCost.Maximum = new System.Decimal(new int[] {
																			 999999,
																			 0,
																			 0,
																			 131072});
			this.updIrradiateCost.Name = "updIrradiateCost";
			this.updIrradiateCost.Size = new System.Drawing.Size(64, 20);
			this.updIrradiateCost.TabIndex = 17;
			this.updIrradiateCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updIrradiateCost.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.updIrradiateCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updIrradiateCost.Leave += new System.EventHandler(this.CostLeave);
			this.updIrradiateCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblSplitDollar
			// 
			this.lblSplitDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblSplitDollar.Location = new System.Drawing.Point(268, 88);
			this.lblSplitDollar.Name = "lblSplitDollar";
			this.lblSplitDollar.Size = new System.Drawing.Size(12, 20);
			this.lblSplitDollar.TabIndex = 13;
			this.lblSplitDollar.Text = "$";
			this.lblSplitDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updSplitDivideCost
			// 
			this.updSplitDivideCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updSplitDivideCost.DecimalPlaces = 2;
			this.updSplitDivideCost.Enabled = false;
			this.updSplitDivideCost.Location = new System.Drawing.Point(280, 88);
			this.updSplitDivideCost.Maximum = new System.Decimal(new int[] {
																			   999999,
																			   0,
																			   0,
																			   131072});
			this.updSplitDivideCost.Name = "updSplitDivideCost";
			this.updSplitDivideCost.Size = new System.Drawing.Size(64, 20);
			this.updSplitDivideCost.TabIndex = 14;
			this.updSplitDivideCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updSplitDivideCost.Value = new System.Decimal(new int[] {
																			 0,
																			 0,
																			 0,
																			 0});
			this.updSplitDivideCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updSplitDivideCost.Leave += new System.EventHandler(this.CostLeave);
			this.updSplitDivideCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblThawPoolCryoDollar
			// 
			this.lblThawPoolCryoDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblThawPoolCryoDollar.Location = new System.Drawing.Point(268, 66);
			this.lblThawPoolCryoDollar.Name = "lblThawPoolCryoDollar";
			this.lblThawPoolCryoDollar.Size = new System.Drawing.Size(12, 20);
			this.lblThawPoolCryoDollar.TabIndex = 10;
			this.lblThawPoolCryoDollar.Text = "$";
			this.lblThawPoolCryoDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updThawPoolCryoCost
			// 
			this.updThawPoolCryoCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updThawPoolCryoCost.DecimalPlaces = 2;
			this.updThawPoolCryoCost.Enabled = false;
			this.updThawPoolCryoCost.Location = new System.Drawing.Point(280, 66);
			this.updThawPoolCryoCost.Maximum = new System.Decimal(new int[] {
																				999999,
																				0,
																				0,
																				131072});
			this.updThawPoolCryoCost.Name = "updThawPoolCryoCost";
			this.updThawPoolCryoCost.Size = new System.Drawing.Size(64, 20);
			this.updThawPoolCryoCost.TabIndex = 11;
			this.updThawPoolCryoCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updThawPoolCryoCost.Value = new System.Decimal(new int[] {
																			  0,
																			  0,
																			  0,
																			  0});
			this.updThawPoolCryoCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updThawPoolCryoCost.Leave += new System.EventHandler(this.CostLeave);
			this.updThawPoolCryoCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblPoolDollar
			// 
			this.lblPoolDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPoolDollar.Location = new System.Drawing.Point(268, 44);
			this.lblPoolDollar.Name = "lblPoolDollar";
			this.lblPoolDollar.Size = new System.Drawing.Size(12, 20);
			this.lblPoolDollar.TabIndex = 7;
			this.lblPoolDollar.Text = "$";
			this.lblPoolDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updPoolCost
			// 
			this.updPoolCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updPoolCost.DecimalPlaces = 2;
			this.updPoolCost.Enabled = false;
			this.updPoolCost.Location = new System.Drawing.Point(280, 44);
			this.updPoolCost.Maximum = new System.Decimal(new int[] {
																		999999,
																		0,
																		0,
																		131072});
			this.updPoolCost.Name = "updPoolCost";
			this.updPoolCost.Size = new System.Drawing.Size(64, 20);
			this.updPoolCost.TabIndex = 8;
			this.updPoolCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updPoolCost.Value = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.updPoolCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updPoolCost.Leave += new System.EventHandler(this.CostLeave);
			this.updPoolCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblThawDollar
			// 
			this.lblThawDollar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblThawDollar.Location = new System.Drawing.Point(268, 22);
			this.lblThawDollar.Name = "lblThawDollar";
			this.lblThawDollar.Size = new System.Drawing.Size(12, 20);
			this.lblThawDollar.TabIndex = 4;
			this.lblThawDollar.Text = "$";
			this.lblThawDollar.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updThawCost
			// 
			this.updThawCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updThawCost.DecimalPlaces = 2;
			this.updThawCost.Enabled = false;
			this.updThawCost.Location = new System.Drawing.Point(280, 22);
			this.updThawCost.Maximum = new System.Decimal(new int[] {
																		999999,
																		0,
																		0,
																		131072});
			this.updThawCost.Name = "updThawCost";
			this.updThawCost.Size = new System.Drawing.Size(64, 20);
			this.updThawCost.TabIndex = 5;
			this.updThawCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updThawCost.Value = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.updThawCost.TextChanged += new System.EventHandler(this.CostChanged);
			this.updThawCost.Leave += new System.EventHandler(this.CostLeave);
			this.updThawCost.ValueChanged += new System.EventHandler(this.CostChanged);
			// 
			// lblCost
			// 
			this.lblCost.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblCost.BackColor = System.Drawing.SystemColors.Control;
			this.lblCost.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblCost.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblCost.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblCost.Location = new System.Drawing.Point(264, 0);
			this.lblCost.Name = "lblCost";
			this.lblCost.Size = new System.Drawing.Size(96, 20);
			this.lblCost.TabIndex = 2;
			this.lblCost.Text = "Cost*";
			this.lblCost.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// cbDeglycerolize
			// 
			this.cbDeglycerolize.AccessibleDescription = "Deglycerolize";
			this.cbDeglycerolize.AccessibleName = "cbDeglycerolize";
			this.cbDeglycerolize.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbDeglycerolize.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbDeglycerolize.Location = new System.Drawing.Point(4, 242);
			this.cbDeglycerolize.Name = "cbDeglycerolize";
			this.cbDeglycerolize.Size = new System.Drawing.Size(240, 20);
			this.cbDeglycerolize.TabIndex = 33;
			this.cbDeglycerolize.Text = "&Deglycerolize";
			this.cbDeglycerolize.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbFreeze
			// 
			this.cbFreeze.AccessibleDescription = "Freeze";
			this.cbFreeze.AccessibleName = "Freeze";
			this.cbFreeze.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbFreeze.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbFreeze.Location = new System.Drawing.Point(4, 220);
			this.cbFreeze.Name = "cbFreeze";
			this.cbFreeze.Size = new System.Drawing.Size(240, 20);
			this.cbFreeze.TabIndex = 30;
			this.cbFreeze.Text = "&Freeze";
			this.cbFreeze.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbRejuvenate
			// 
			this.cbRejuvenate.AccessibleDescription = "Rejuvenate";
			this.cbRejuvenate.AccessibleName = "Rejuvenate";
			this.cbRejuvenate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbRejuvenate.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbRejuvenate.Location = new System.Drawing.Point(4, 198);
			this.cbRejuvenate.Name = "cbRejuvenate";
			this.cbRejuvenate.Size = new System.Drawing.Size(240, 20);
			this.cbRejuvenate.TabIndex = 27;
			this.cbRejuvenate.Text = "&Rejuvenate";
			this.cbRejuvenate.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbWash
			// 
			this.cbWash.AccessibleDescription = "Wash";
			this.cbWash.AccessibleName = "Wash";
			this.cbWash.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbWash.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbWash.Location = new System.Drawing.Point(4, 176);
			this.cbWash.Name = "cbWash";
			this.cbWash.Size = new System.Drawing.Size(240, 20);
			this.cbWash.TabIndex = 24;
			this.cbWash.Text = "&Wash";
			this.cbWash.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbVolumeReduce
			// 
			this.cbVolumeReduce.AccessibleDescription = "Volume Reduce";
			this.cbVolumeReduce.AccessibleName = "Volume Reduce";
			this.cbVolumeReduce.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbVolumeReduce.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbVolumeReduce.Location = new System.Drawing.Point(4, 154);
			this.cbVolumeReduce.Name = "cbVolumeReduce";
			this.cbVolumeReduce.Size = new System.Drawing.Size(240, 20);
			this.cbVolumeReduce.TabIndex = 21;
			this.cbVolumeReduce.Text = "&Volume Reduce";
			this.cbVolumeReduce.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbLeukoreduce
			// 
			this.cbLeukoreduce.AccessibleDescription = "Leukoreduce";
			this.cbLeukoreduce.AccessibleName = "Leukoreduce";
			this.cbLeukoreduce.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbLeukoreduce.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbLeukoreduce.Location = new System.Drawing.Point(4, 132);
			this.cbLeukoreduce.Name = "cbLeukoreduce";
			this.cbLeukoreduce.Size = new System.Drawing.Size(240, 20);
			this.cbLeukoreduce.TabIndex = 18;
			this.cbLeukoreduce.Text = "&Leukoreduce";
			this.cbLeukoreduce.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbIrradiate
			// 
			this.cbIrradiate.AccessibleDescription = "Irradiate";
			this.cbIrradiate.AccessibleName = "Irradiate";
			this.cbIrradiate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbIrradiate.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbIrradiate.Location = new System.Drawing.Point(4, 110);
			this.cbIrradiate.Name = "cbIrradiate";
			this.cbIrradiate.Size = new System.Drawing.Size(240, 20);
			this.cbIrradiate.TabIndex = 15;
			this.cbIrradiate.Text = "&Irradiate";
			this.cbIrradiate.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbSplit
			// 
			this.cbSplit.AccessibleDescription = "Split Divide";
			this.cbSplit.AccessibleName = "Split Divide";
			this.cbSplit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbSplit.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbSplit.Location = new System.Drawing.Point(4, 88);
			this.cbSplit.Name = "cbSplit";
			this.cbSplit.Size = new System.Drawing.Size(240, 20);
			this.cbSplit.TabIndex = 12;
			this.cbSplit.Text = "&Split/Divide";
			this.cbSplit.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbPool
			// 
			this.cbPool.AccessibleDescription = "Pool";
			this.cbPool.AccessibleName = "Pool";
			this.cbPool.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbPool.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbPool.Location = new System.Drawing.Point(4, 44);
			this.cbPool.Name = "cbPool";
			this.cbPool.Size = new System.Drawing.Size(240, 20);
			this.cbPool.TabIndex = 6;
			this.cbPool.Text = "&Pool";
			this.cbPool.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// cbThaw
			// 
			this.cbThaw.AccessibleDescription = "Thaw";
			this.cbThaw.AccessibleName = "Thaw";
			this.cbThaw.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbThaw.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbThaw.Location = new System.Drawing.Point(4, 22);
			this.cbThaw.Name = "cbThaw";
			this.cbThaw.Size = new System.Drawing.Size(240, 20);
			this.cbThaw.TabIndex = 3;
			this.cbThaw.Text = "&Thaw";
			this.cbThaw.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// lblEnabled
			// 
			this.lblEnabled.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblEnabled.BackColor = System.Drawing.SystemColors.Control;
			this.lblEnabled.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblEnabled.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblEnabled.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblEnabled.Location = new System.Drawing.Point(208, 0);
			this.lblEnabled.Name = "lblEnabled";
			this.lblEnabled.Size = new System.Drawing.Size(56, 20);
			this.lblEnabled.TabIndex = 1;
			this.lblEnabled.Text = "Enabled";
			this.lblEnabled.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblProcedures
			// 
			this.lblProcedures.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblProcedures.BackColor = System.Drawing.SystemColors.Control;
			this.lblProcedures.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblProcedures.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblProcedures.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblProcedures.Location = new System.Drawing.Point(0, 0);
			this.lblProcedures.Name = "lblProcedures";
			this.lblProcedures.Size = new System.Drawing.Size(208, 20);
			this.lblProcedures.TabIndex = 0;
			this.lblProcedures.Text = "  Modification Procedure";
			this.lblProcedures.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbThawPool
			// 
			this.cbThawPool.AccessibleDescription = "Thaw Pool Cryo";
			this.cbThawPool.AccessibleName = "Thaw Pool Cryo";
			this.cbThawPool.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbThawPool.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbThawPool.Location = new System.Drawing.Point(4, 66);
			this.cbThawPool.Name = "cbThawPool";
			this.cbThawPool.Size = new System.Drawing.Size(240, 20);
			this.cbThawPool.TabIndex = 9;
			this.cbThawPool.Text = "Thaw/ Pool Cr&yo";
			this.cbThawPool.CheckedChanged += new System.EventHandler(this.CheckedChanged);
			// 
			// pageOrderAlerts
			// 
			this.pageOrderAlerts.Controls.Add(this.grpOrderAlerts);
			this.pageOrderAlerts.Controls.Add(this.grpAlertImage);
			this.pageOrderAlerts.Location = new System.Drawing.Point(4, 42);
			this.pageOrderAlerts.Name = "pageOrderAlerts";
			this.pageOrderAlerts.Size = new System.Drawing.Size(436, 286);
			this.pageOrderAlerts.TabIndex = 3;
			this.pageOrderAlerts.Text = "Order Alerts";
			// 
			// grpOrderAlerts
			// 
			this.grpOrderAlerts.AccessibleDescription = "Configure mechanisms that will alert users when diagnostic test and or component " +
				"orders are received in VBECS.";
			this.grpOrderAlerts.AccessibleName = "Configure mechanisms that will alert users when diagnostic test and or component " +
				"orders are received in VBECS.";
			this.grpOrderAlerts.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpOrderAlerts.Controls.Add(this.lblOrderAlerts);
			this.grpOrderAlerts.Controls.Add(this.grpIconAlerts);
			this.grpOrderAlerts.Controls.Add(this.grpPrinterAlerts);
			this.grpOrderAlerts.Location = new System.Drawing.Point(56, 0);
			this.grpOrderAlerts.Name = "grpOrderAlerts";
			this.grpOrderAlerts.Size = new System.Drawing.Size(380, 286);
			this.grpOrderAlerts.TabIndex = 0;
			this.grpOrderAlerts.TabStop = false;
			// 
			// lblOrderAlerts
			// 
			this.lblOrderAlerts.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblOrderAlerts.Location = new System.Drawing.Point(8, 12);
			this.lblOrderAlerts.Name = "lblOrderAlerts";
			this.lblOrderAlerts.Size = new System.Drawing.Size(356, 28);
			this.lblOrderAlerts.TabIndex = 0;
			this.lblOrderAlerts.Text = "Configure mechanism(s) that will alert users when diagnostic test and/or componen" +
				"t orders are received in VBECS.";
			// 
			// grpIconAlerts
			// 
			this.grpIconAlerts.Controls.Add(this.pnlIconAlerts);
			this.grpIconAlerts.Controls.Add(this.cbIconAlerts);
			this.grpIconAlerts.Location = new System.Drawing.Point(8, 148);
			this.grpIconAlerts.Name = "grpIconAlerts";
			this.grpIconAlerts.Size = new System.Drawing.Size(356, 100);
			this.grpIconAlerts.TabIndex = 2;
			this.grpIconAlerts.TabStop = false;
			// 
			// pnlIconAlerts
			// 
			this.pnlIconAlerts.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlIconAlerts.Controls.Add(this.pnlIconOrdersNeeded);
			this.pnlIconAlerts.Controls.Add(this.lblSeconds);
			this.pnlIconAlerts.Controls.Add(this.updRefreshRate);
			this.pnlIconAlerts.Controls.Add(this.cmbIconAlertType);
			this.pnlIconAlerts.Controls.Add(this.lblIconAlertType);
			this.pnlIconAlerts.Controls.Add(this.lblRefreshRate);
			this.pnlIconAlerts.Enabled = false;
			this.pnlIconAlerts.Location = new System.Drawing.Point(8, 16);
			this.pnlIconAlerts.Name = "pnlIconAlerts";
			this.pnlIconAlerts.Size = new System.Drawing.Size(344, 76);
			this.pnlIconAlerts.TabIndex = 1;
			this.pnlIconAlerts.EnabledChanged += new System.EventHandler(this.pnlIconAlerts_EnabledChanged);
			// 
			// pnlIconOrdersNeeded
			// 
			this.pnlIconOrdersNeeded.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlIconOrdersNeeded.Controls.Add(this.lblIconHours);
			this.pnlIconOrdersNeeded.Controls.Add(this.updIconOrdersNeeded);
			this.pnlIconOrdersNeeded.Controls.Add(this.lblIconOrdersNeeded);
			this.pnlIconOrdersNeeded.Location = new System.Drawing.Point(0, 52);
			this.pnlIconOrdersNeeded.Name = "pnlIconOrdersNeeded";
			this.pnlIconOrdersNeeded.Size = new System.Drawing.Size(344, 24);
			this.pnlIconOrdersNeeded.TabIndex = 5;
			this.pnlIconOrdersNeeded.Visible = false;
			// 
			// lblIconHours
			// 
			this.lblIconHours.Location = new System.Drawing.Point(156, 0);
			this.lblIconHours.Name = "lblIconHours";
			this.lblIconHours.Size = new System.Drawing.Size(32, 20);
			this.lblIconHours.TabIndex = 2;
			this.lblIconHours.Text = "hours";
			this.lblIconHours.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updIconOrdersNeeded
			// 
			this.updIconOrdersNeeded.AccessibleDescription = "Orders Needed In Hours";
			this.updIconOrdersNeeded.AccessibleName = "Orders Needed In Hours";
			this.updIconOrdersNeeded.Location = new System.Drawing.Point(100, 0);
			this.updIconOrdersNeeded.Maximum = new System.Decimal(new int[] {
																				168,
																				0,
																				0,
																				0});
			this.updIconOrdersNeeded.Minimum = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.updIconOrdersNeeded.Name = "updIconOrdersNeeded";
			this.updIconOrdersNeeded.Size = new System.Drawing.Size(56, 20);
			this.updIconOrdersNeeded.TabIndex = 1;
			this.updIconOrdersNeeded.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updIconOrdersNeeded.Value = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  0});
			this.updIconOrdersNeeded.TextChanged += new System.EventHandler(this.updIconOrdersNeeded_ValueChanged);
			this.updIconOrdersNeeded.Leave += new System.EventHandler(this.updIconOrdersNeeded_Leave);
			this.updIconOrdersNeeded.ValueChanged += new System.EventHandler(this.updIconOrdersNeeded_ValueChanged);
			// 
			// lblIconOrdersNeeded
			// 
			this.lblIconOrdersNeeded.Location = new System.Drawing.Point(4, 0);
			this.lblIconOrdersNeeded.Name = "lblIconOrdersNeeded";
			this.lblIconOrdersNeeded.Size = new System.Drawing.Size(100, 20);
			this.lblIconOrdersNeeded.TabIndex = 0;
			this.lblIconOrdersNeeded.Text = "Orders Needed In*";
			this.lblIconOrdersNeeded.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSeconds
			// 
			this.lblSeconds.Location = new System.Drawing.Point(156, 4);
			this.lblSeconds.Name = "lblSeconds";
			this.lblSeconds.Size = new System.Drawing.Size(48, 20);
			this.lblSeconds.TabIndex = 2;
			this.lblSeconds.Text = "seconds";
			this.lblSeconds.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updRefreshRate
			// 
			this.updRefreshRate.AccessibleDescription = "Refresh Rate Seconds";
			this.updRefreshRate.AccessibleName = "Refresh Rate Seconds";
			this.updRefreshRate.Increment = new System.Decimal(new int[] {
																			 5,
																			 0,
																			 0,
																			 0});
			this.updRefreshRate.Location = new System.Drawing.Point(100, 4);
			this.updRefreshRate.Maximum = new System.Decimal(new int[] {
																		   86400,
																		   0,
																		   0,
																		   0});
			this.updRefreshRate.Minimum = new System.Decimal(new int[] {
																		   5,
																		   0,
																		   0,
																		   0});
			this.updRefreshRate.Name = "updRefreshRate";
			this.updRefreshRate.Size = new System.Drawing.Size(56, 20);
			this.updRefreshRate.TabIndex = 1;
			this.updRefreshRate.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updRefreshRate.Value = new System.Decimal(new int[] {
																		 5,
																		 0,
																		 0,
																		 0});
			this.updRefreshRate.TextChanged += new System.EventHandler(this.updRefreshRate_ValueChanged);
			this.updRefreshRate.Leave += new System.EventHandler(this.updRefreshRate_Leave);
			this.updRefreshRate.ValueChanged += new System.EventHandler(this.updRefreshRate_ValueChanged);
			// 
			// cmbIconAlertType
			// 
			this.cmbIconAlertType.AccessibleDescription = "Order Alert Type";
			this.cmbIconAlertType.AccessibleName = "Order Alert Type";
			this.cmbIconAlertType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbIconAlertType.Interval = 500;
			this.cmbIconAlertType.Location = new System.Drawing.Point(100, 28);
			this.cmbIconAlertType.MaxLength = 25;
			this.cmbIconAlertType.Name = "cmbIconAlertType";
			this.cmbIconAlertType.Size = new System.Drawing.Size(228, 22);
			this.cmbIconAlertType.TabIndex = 4;
			this.cmbIconAlertType.SelectedIndexChanged += new System.EventHandler(this.cmbIconAlertType_SelectedIndexChanged);
			// 
			// lblIconAlertType
			// 
			this.lblIconAlertType.Location = new System.Drawing.Point(4, 28);
			this.lblIconAlertType.Name = "lblIconAlertType";
			this.lblIconAlertType.Size = new System.Drawing.Size(92, 20);
			this.lblIconAlertType.TabIndex = 3;
			this.lblIconAlertType.Text = "Order Alert Type*";
			this.lblIconAlertType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblRefreshRate
			// 
			this.lblRefreshRate.Location = new System.Drawing.Point(4, 4);
			this.lblRefreshRate.Name = "lblRefreshRate";
			this.lblRefreshRate.Size = new System.Drawing.Size(76, 20);
			this.lblRefreshRate.TabIndex = 0;
			this.lblRefreshRate.Text = "Refresh Rate*";
			this.lblRefreshRate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbIconAlerts
			// 
			this.cbIconAlerts.AccessibleDescription = "Icon Alerts";
			this.cbIconAlerts.AccessibleName = "Icon Alerts";
			this.cbIconAlerts.Location = new System.Drawing.Point(8, 0);
			this.cbIconAlerts.Name = "cbIconAlerts";
			this.cbIconAlerts.Size = new System.Drawing.Size(108, 16);
			this.cbIconAlerts.TabIndex = 0;
			this.cbIconAlerts.Text = "&Icon Alerts On";
			this.cbIconAlerts.CheckedChanged += new System.EventHandler(this.cbIconAlerts_CheckedChanged);
			// 
			// grpPrinterAlerts
			// 
			this.grpPrinterAlerts.AccessibleDescription = "Printer Alerts";
			this.grpPrinterAlerts.AccessibleName = "Printer Alerts";
			this.grpPrinterAlerts.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPrinterAlerts.Controls.Add(this.cbPrinterAlerts);
			this.grpPrinterAlerts.Controls.Add(this.pnlPrinterAlerts);
			this.grpPrinterAlerts.Location = new System.Drawing.Point(8, 44);
			this.grpPrinterAlerts.Name = "grpPrinterAlerts";
			this.grpPrinterAlerts.Size = new System.Drawing.Size(366, 100);
			this.grpPrinterAlerts.TabIndex = 1;
			this.grpPrinterAlerts.TabStop = false;
			// 
			// cbPrinterAlerts
			// 
			this.cbPrinterAlerts.AccessibleDescription = "Printer Alerts On";
			this.cbPrinterAlerts.AccessibleName = "Printer Alerts On";
			this.cbPrinterAlerts.Location = new System.Drawing.Point(8, 0);
			this.cbPrinterAlerts.Name = "cbPrinterAlerts";
			this.cbPrinterAlerts.Size = new System.Drawing.Size(108, 16);
			this.cbPrinterAlerts.TabIndex = 0;
			this.cbPrinterAlerts.Text = "&Printer Alerts On";
			this.cbPrinterAlerts.CheckedChanged += new System.EventHandler(this.cbPrinterAlerts_CheckedChanged);
			// 
			// pnlPrinterAlerts
			// 
			this.pnlPrinterAlerts.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPrinterAlerts.Controls.Add(this.pnlPrinterOrdersNeeded);
			this.pnlPrinterAlerts.Controls.Add(this.cmbPrinterAlertType);
			this.pnlPrinterAlerts.Controls.Add(this.lblPrinterAlertType);
			this.pnlPrinterAlerts.Controls.Add(this.cmbPrinterName);
			this.pnlPrinterAlerts.Controls.Add(this.lblPrinterName);
			this.pnlPrinterAlerts.Enabled = false;
			this.pnlPrinterAlerts.Location = new System.Drawing.Point(8, 16);
			this.pnlPrinterAlerts.Name = "pnlPrinterAlerts";
			this.pnlPrinterAlerts.Size = new System.Drawing.Size(354, 76);
			this.pnlPrinterAlerts.TabIndex = 1;
			this.pnlPrinterAlerts.EnabledChanged += new System.EventHandler(this.pnlPrinterAlerts_EnabledChanged);
			// 
			// pnlPrinterOrdersNeeded
			// 
			this.pnlPrinterOrdersNeeded.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPrinterOrdersNeeded.Controls.Add(this.lblPrinterHours);
			this.pnlPrinterOrdersNeeded.Controls.Add(this.updPrinterOrdersNeeded);
			this.pnlPrinterOrdersNeeded.Controls.Add(this.lblPrinterOrdersNeeded);
			this.pnlPrinterOrdersNeeded.Location = new System.Drawing.Point(0, 52);
			this.pnlPrinterOrdersNeeded.Name = "pnlPrinterOrdersNeeded";
			this.pnlPrinterOrdersNeeded.Size = new System.Drawing.Size(354, 24);
			this.pnlPrinterOrdersNeeded.TabIndex = 4;
			this.pnlPrinterOrdersNeeded.Visible = false;
			// 
			// lblPrinterHours
			// 
			this.lblPrinterHours.Location = new System.Drawing.Point(156, 0);
			this.lblPrinterHours.Name = "lblPrinterHours";
			this.lblPrinterHours.Size = new System.Drawing.Size(32, 20);
			this.lblPrinterHours.TabIndex = 2;
			this.lblPrinterHours.Text = "hours";
			this.lblPrinterHours.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updPrinterOrdersNeeded
			// 
			this.updPrinterOrdersNeeded.AccessibleDescription = "Orders Needed In Hours";
			this.updPrinterOrdersNeeded.AccessibleName = "Orders Needed In Hours";
			this.updPrinterOrdersNeeded.Location = new System.Drawing.Point(100, 0);
			this.updPrinterOrdersNeeded.Maximum = new System.Decimal(new int[] {
																				   168,
																				   0,
																				   0,
																				   0});
			this.updPrinterOrdersNeeded.Minimum = new System.Decimal(new int[] {
																				   1,
																				   0,
																				   0,
																				   0});
			this.updPrinterOrdersNeeded.Name = "updPrinterOrdersNeeded";
			this.updPrinterOrdersNeeded.Size = new System.Drawing.Size(56, 20);
			this.updPrinterOrdersNeeded.TabIndex = 1;
			this.updPrinterOrdersNeeded.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updPrinterOrdersNeeded.Value = new System.Decimal(new int[] {
																				 1,
																				 0,
																				 0,
																				 0});
			this.updPrinterOrdersNeeded.TextChanged += new System.EventHandler(this.updPrinterOrdersNeeded_ValueChanged);
			this.updPrinterOrdersNeeded.Leave += new System.EventHandler(this.updPrinterOrdersNeeded_Leave);
			this.updPrinterOrdersNeeded.ValueChanged += new System.EventHandler(this.updPrinterOrdersNeeded_ValueChanged);
			// 
			// lblPrinterOrdersNeeded
			// 
			this.lblPrinterOrdersNeeded.Location = new System.Drawing.Point(4, 0);
			this.lblPrinterOrdersNeeded.Name = "lblPrinterOrdersNeeded";
			this.lblPrinterOrdersNeeded.Size = new System.Drawing.Size(100, 20);
			this.lblPrinterOrdersNeeded.TabIndex = 0;
			this.lblPrinterOrdersNeeded.Text = "Orders Needed In*";
			this.lblPrinterOrdersNeeded.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbPrinterAlertType
			// 
			this.cmbPrinterAlertType.AccessibleDescription = "Order Alert Type";
			this.cmbPrinterAlertType.AccessibleName = "Order Alert Type";
			this.cmbPrinterAlertType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterAlertType.Interval = 500;
			this.cmbPrinterAlertType.Location = new System.Drawing.Point(100, 28);
			this.cmbPrinterAlertType.MaxLength = 25;
			this.cmbPrinterAlertType.Name = "cmbPrinterAlertType";
			this.cmbPrinterAlertType.Size = new System.Drawing.Size(238, 22);
			this.cmbPrinterAlertType.TabIndex = 3;
			this.cmbPrinterAlertType.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterAlertType_SelectedIndexChanged);
			// 
			// lblPrinterAlertType
			// 
			this.lblPrinterAlertType.Location = new System.Drawing.Point(4, 28);
			this.lblPrinterAlertType.Name = "lblPrinterAlertType";
			this.lblPrinterAlertType.Size = new System.Drawing.Size(92, 20);
			this.lblPrinterAlertType.TabIndex = 2;
			this.lblPrinterAlertType.Text = "Order Alert Type*";
			this.lblPrinterAlertType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.AccessibleDescription = "Printer Name";
			this.cmbPrinterName.AccessibleName = "Printer Name";
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(100, 4);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(238, 22);
			this.cmbPrinterName.TabIndex = 1;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(4, 4);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 0;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpAlertImage
			// 
			this.grpAlertImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpAlertImage.Controls.Add(this.picAlert);
			this.grpAlertImage.Location = new System.Drawing.Point(0, 0);
			this.grpAlertImage.Name = "grpAlertImage";
			this.grpAlertImage.Size = new System.Drawing.Size(52, 286);
			this.grpAlertImage.TabIndex = 1;
			this.grpAlertImage.TabStop = false;
			// 
			// picAlert
			// 
			this.picAlert.Image = ((System.Drawing.Image)(resources.GetObject("picAlert.Image")));
			this.picAlert.Location = new System.Drawing.Point(4, 12);
			this.picAlert.Name = "picAlert";
			this.picAlert.Size = new System.Drawing.Size(45, 45);
			this.picAlert.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picAlert.TabIndex = 0;
			this.picAlert.TabStop = false;
			// 
			// pageTesting
			// 
			this.pageTesting.Controls.Add(this.grpTestingImage);
			this.pageTesting.Controls.Add(this.grpTestingInfo);
			this.pageTesting.Location = new System.Drawing.Point(4, 42);
			this.pageTesting.Name = "pageTesting";
			this.pageTesting.Size = new System.Drawing.Size(436, 286);
			this.pageTesting.TabIndex = 1;
			this.pageTesting.Text = "Configure Testing";
			// 
			// grpTestingImage
			// 
			this.grpTestingImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpTestingImage.Controls.Add(this.picTesting);
			this.grpTestingImage.Location = new System.Drawing.Point(0, 0);
			this.grpTestingImage.Name = "grpTestingImage";
			this.grpTestingImage.Size = new System.Drawing.Size(52, 286);
			this.grpTestingImage.TabIndex = 1;
			this.grpTestingImage.TabStop = false;
			// 
			// picTesting
			// 
			this.picTesting.Image = ((System.Drawing.Image)(resources.GetObject("picTesting.Image")));
			this.picTesting.Location = new System.Drawing.Point(4, 12);
			this.picTesting.Name = "picTesting";
			this.picTesting.Size = new System.Drawing.Size(45, 45);
			this.picTesting.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picTesting.TabIndex = 1;
			this.picTesting.TabStop = false;
			// 
			// grpTestingInfo
			// 
			this.grpTestingInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingInfo.Controls.Add(this.pnlReactivityPhase);
			this.grpTestingInfo.Controls.Add(this.pnlServiceType);
			this.grpTestingInfo.Controls.Add(this.grpLine4);
			this.grpTestingInfo.Controls.Add(this.pnlXmatch);
			this.grpTestingInfo.Controls.Add(this.grpLine2);
			this.grpTestingInfo.Controls.Add(this.pnlAntibodyScreen);
			this.grpTestingInfo.Controls.Add(this.grpLine3);
			this.grpTestingInfo.Location = new System.Drawing.Point(56, 0);
			this.grpTestingInfo.Name = "grpTestingInfo";
			this.grpTestingInfo.Size = new System.Drawing.Size(380, 286);
			this.grpTestingInfo.TabIndex = 0;
			this.grpTestingInfo.TabStop = false;
			// 
			// pnlReactivityPhase
			// 
			this.pnlReactivityPhase.AccessibleDescription = "A B S and Crossmatch Testing Phases";
			this.pnlReactivityPhase.AccessibleName = "A B S and Crossmatch Testing Phases";
			this.pnlReactivityPhase.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlReactivityPhase.Controls.Add(this.rdoAllPhases);
			this.pnlReactivityPhase.Controls.Add(this.rdoAHGOnly);
			this.pnlReactivityPhase.Controls.Add(this.label1);
			this.pnlReactivityPhase.Location = new System.Drawing.Point(5, 164);
			this.pnlReactivityPhase.Name = "pnlReactivityPhase";
			this.pnlReactivityPhase.Size = new System.Drawing.Size(370, 68);
			this.pnlReactivityPhase.TabIndex = 6;
			// 
			// rdoAllPhases
			// 
			this.rdoAllPhases.AccessibleDescription = "All Phases";
			this.rdoAllPhases.AccessibleName = "All Phases";
			this.rdoAllPhases.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAllPhases.Checked = true;
			this.rdoAllPhases.Location = new System.Drawing.Point(116, 4);
			this.rdoAllPhases.Name = "rdoAllPhases";
			this.rdoAllPhases.Size = new System.Drawing.Size(246, 20);
			this.rdoAllPhases.TabIndex = 1;
			this.rdoAllPhases.TabStop = true;
			this.rdoAllPhases.Text = "All &Phases";
			this.rdoAllPhases.CheckedChanged += new System.EventHandler(this.rdoAllPhases_CheckedChanged);
			// 
			// rdoAHGOnly
			// 
			this.rdoAHGOnly.AccessibleDescription = "A H G Only";
			this.rdoAHGOnly.AccessibleName = "A H G Only";
			this.rdoAHGOnly.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAHGOnly.Location = new System.Drawing.Point(116, 24);
			this.rdoAHGOnly.Name = "rdoAHGOnly";
			this.rdoAHGOnly.Size = new System.Drawing.Size(246, 20);
			this.rdoAHGOnly.TabIndex = 2;
			this.rdoAHGOnly.Text = "&AHG Only";
			this.rdoAHGOnly.CheckedChanged += new System.EventHandler(this.rdoAHGOnly_CheckedChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(0, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(124, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "ABS and XM Testing Phases*";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlServiceType
			// 
			this.pnlServiceType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlServiceType.Controls.Add(this.lblServiceType);
			this.pnlServiceType.Controls.Add(this.txtServiceType);
			this.pnlServiceType.Location = new System.Drawing.Point(4, 8);
			this.pnlServiceType.Name = "pnlServiceType";
			this.pnlServiceType.Size = new System.Drawing.Size(370, 28);
			this.pnlServiceType.TabIndex = 0;
			// 
			// lblServiceType
			// 
			this.lblServiceType.Location = new System.Drawing.Point(0, 4);
			this.lblServiceType.Name = "lblServiceType";
			this.lblServiceType.Size = new System.Drawing.Size(112, 20);
			this.lblServiceType.TabIndex = 0;
			this.lblServiceType.Text = "Service Type";
			this.lblServiceType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtServiceType
			// 
			this.txtServiceType.AccessibleDescription = "Service Type";
			this.txtServiceType.AccessibleName = "Service Type";
			this.txtServiceType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtServiceType.Location = new System.Drawing.Point(116, 4);
			this.txtServiceType.Name = "txtServiceType";
			this.txtServiceType.ReadOnly = true;
			this.txtServiceType.Size = new System.Drawing.Size(248, 20);
			this.txtServiceType.TabIndex = 6;
			this.txtServiceType.Text = "";
			// 
			// grpLine4
			// 
			this.grpLine4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLine4.Location = new System.Drawing.Point(4, 32);
			this.grpLine4.Name = "grpLine4";
			this.grpLine4.Size = new System.Drawing.Size(370, 7);
			this.grpLine4.TabIndex = 1;
			this.grpLine4.TabStop = false;
			// 
			// pnlXmatch
			// 
			this.pnlXmatch.AccessibleDescription = "Electronic Crossmatch";
			this.pnlXmatch.AccessibleName = "Electronic Crossmatch";
			this.pnlXmatch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlXmatch.Controls.Add(this.rdoXmatchEnabled);
			this.pnlXmatch.Controls.Add(this.rdoXmatchDisabled);
			this.pnlXmatch.Controls.Add(this.lblXMatch);
			this.pnlXmatch.Location = new System.Drawing.Point(4, 40);
			this.pnlXmatch.Name = "pnlXmatch";
			this.pnlXmatch.Size = new System.Drawing.Size(370, 48);
			this.pnlXmatch.TabIndex = 2;
			// 
			// lblXMatch
			// 
			this.lblXMatch.Location = new System.Drawing.Point(0, 4);
			this.lblXMatch.Name = "lblXMatch";
			this.lblXMatch.Size = new System.Drawing.Size(124, 20);
			this.lblXMatch.TabIndex = 0;
			this.lblXMatch.Text = "Electronic Crossmatch*";
			this.lblXMatch.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpLine2
			// 
			this.grpLine2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLine2.Location = new System.Drawing.Point(4, 84);
			this.grpLine2.Name = "grpLine2";
			this.grpLine2.Size = new System.Drawing.Size(370, 7);
			this.grpLine2.TabIndex = 3;
			this.grpLine2.TabStop = false;
			// 
			// pnlAntibodyScreen
			// 
			this.pnlAntibodyScreen.AccessibleDescription = "Antibody Screen";
			this.pnlAntibodyScreen.AccessibleName = "Antibody Screen";
			this.pnlAntibodyScreen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlAntibodyScreen.Controls.Add(this.rdoABSOnly);
			this.pnlAntibodyScreen.Controls.Add(this.rdoABSDAT);
			this.pnlAntibodyScreen.Controls.Add(this.rdoABSAutoControl);
			this.pnlAntibodyScreen.Controls.Add(this.lblAntibodyScreen);
			this.pnlAntibodyScreen.Location = new System.Drawing.Point(4, 92);
			this.pnlAntibodyScreen.Name = "pnlAntibodyScreen";
			this.pnlAntibodyScreen.Size = new System.Drawing.Size(370, 68);
			this.pnlAntibodyScreen.TabIndex = 4;
			// 
			// lblAntibodyScreen
			// 
			this.lblAntibodyScreen.Location = new System.Drawing.Point(0, 4);
			this.lblAntibodyScreen.Name = "lblAntibodyScreen";
			this.lblAntibodyScreen.Size = new System.Drawing.Size(124, 20);
			this.lblAntibodyScreen.TabIndex = 0;
			this.lblAntibodyScreen.Text = "Antibody Screen*";
			this.lblAntibodyScreen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpLine3
			// 
			this.grpLine3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLine3.Location = new System.Drawing.Point(4, 156);
			this.grpLine3.Name = "grpLine3";
			this.grpLine3.Size = new System.Drawing.Size(370, 7);
			this.grpLine3.TabIndex = 5;
			this.grpLine3.TabStop = false;
			// 
			// pageLoginMessage
			// 
			this.pageLoginMessage.Controls.Add(this.grpLoginMessage);
			this.pageLoginMessage.Controls.Add(this.grpMessageImage);
			this.pageLoginMessage.Location = new System.Drawing.Point(4, 42);
			this.pageLoginMessage.Name = "pageLoginMessage";
			this.pageLoginMessage.Size = new System.Drawing.Size(436, 286);
			this.pageLoginMessage.TabIndex = 4;
			this.pageLoginMessage.Text = "Login Message";
			// 
			// grpLoginMessage
			// 
			this.grpLoginMessage.AccessibleDescription = "Login Message to display to all users after they log into VBECS";
			this.grpLoginMessage.AccessibleName = "Login Message to display to all users after they log into VBECS";
			this.grpLoginMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLoginMessage.Controls.Add(this.btnClear);
			this.grpLoginMessage.Controls.Add(this.rtxtLoginMessage);
			this.grpLoginMessage.Controls.Add(this.lblLoginMessage);
			this.grpLoginMessage.Location = new System.Drawing.Point(56, 0);
			this.grpLoginMessage.Name = "grpLoginMessage";
			this.grpLoginMessage.Size = new System.Drawing.Size(380, 286);
			this.grpLoginMessage.TabIndex = 0;
			this.grpLoginMessage.TabStop = false;
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.btnClear.CausesValidation = false;
			this.btnClear.Location = new System.Drawing.Point(8, 257);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 2;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// rtxtLoginMessage
			// 
			this.rtxtLoginMessage.AccessibleDescription = "Login Message";
			this.rtxtLoginMessage.AccessibleName = "Login Message";
			this.rtxtLoginMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rtxtLoginMessage.AutoWordSelection = true;
			this.rtxtLoginMessage.BulletIndent = 4;
			this.rtxtLoginMessage.ContextMenu = this.mnuCutCopyPaste;
			this.rtxtLoginMessage.Location = new System.Drawing.Point(8, 32);
			this.rtxtLoginMessage.MaxLength = 255;
			this.rtxtLoginMessage.Name = "rtxtLoginMessage";
			this.rtxtLoginMessage.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
			this.rtxtLoginMessage.Size = new System.Drawing.Size(364, 221);
			this.rtxtLoginMessage.TabIndex = 1;
			this.rtxtLoginMessage.Text = "";
			this.rtxtLoginMessage.TextChanged += new System.EventHandler(this.rtxtLoginMessage_TextChanged);
			this.rtxtLoginMessage.LinkClicked += new System.Windows.Forms.LinkClickedEventHandler(this.rtxtLoginMessage_LinkClicked);
			// 
			// lblLoginMessage
			// 
			this.lblLoginMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblLoginMessage.Location = new System.Drawing.Point(8, 12);
			this.lblLoginMessage.Name = "lblLoginMessage";
			this.lblLoginMessage.Size = new System.Drawing.Size(342, 20);
			this.lblLoginMessage.TabIndex = 0;
			this.lblLoginMessage.Text = "Message to display to all users after they log into VBECS";
			this.lblLoginMessage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpMessageImage
			// 
			this.grpMessageImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpMessageImage.Controls.Add(this.picMessageImage);
			this.grpMessageImage.Location = new System.Drawing.Point(0, 0);
			this.grpMessageImage.Name = "grpMessageImage";
			this.grpMessageImage.Size = new System.Drawing.Size(52, 286);
			this.grpMessageImage.TabIndex = 1;
			this.grpMessageImage.TabStop = false;
			// 
			// picMessageImage
			// 
			this.picMessageImage.Image = ((System.Drawing.Image)(resources.GetObject("picMessageImage.Image")));
			this.picMessageImage.Location = new System.Drawing.Point(4, 12);
			this.picMessageImage.Name = "picMessageImage";
			this.picMessageImage.Size = new System.Drawing.Size(45, 45);
			this.picMessageImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picMessageImage.TabIndex = 0;
			this.picMessageImage.TabStop = false;
			// 
			// grpDivision
			// 
			this.grpDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivision.Controls.Add(this.txtName);
			this.grpDivision.Controls.Add(this.lblName);
			this.grpDivision.Controls.Add(this.txtCode);
			this.grpDivision.Controls.Add(this.lblCode);
			this.grpDivision.Location = new System.Drawing.Point(4, 28);
			this.grpDivision.Name = "grpDivision";
			this.grpDivision.Size = new System.Drawing.Size(442, 36);
			this.grpDivision.TabIndex = 0;
			this.grpDivision.TabStop = false;
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(180, 10);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(84, 20);
			this.lblName.TabIndex = 2;
			this.lblName.Text = "Division Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCode
			// 
			this.lblCode.Location = new System.Drawing.Point(12, 10);
			this.lblCode.Name = "lblCode";
			this.lblCode.Size = new System.Drawing.Size(84, 20);
			this.lblCode.TabIndex = 0;
			this.lblCode.Text = "Division Code";
			this.lblCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgMaintainDivision
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(452, 433);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.tabOptions);
			this.Controls.Add(this.grpDivision);
			this.hlphelpChm.SetHelpKeyword(this, "Configure_Division.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(460, 460);
			this.Name = "DlgMaintainDivision";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - System Configuration";
			this.Load += new System.EventHandler(this.DlgMaintainDivision_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgMaintainDivision_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpDivision, 0);
			this.Controls.SetChildIndex(this.tabOptions, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.tabOptions.ResumeLayout(false);
			this.pageDivision.ResumeLayout(false);
			this.grpDivisionInfo.ResumeLayout(false);
			this.pnlBloodBankMD.ResumeLayout(false);
			this.pnlMaxSpecimenExpiration.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updMaxSpecimenExpiration)).EndInit();
			this.pnlICCBBA.ResumeLayout(false);
			this.grpDivisionImage.ResumeLayout(false);
			this.tabProductMods.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.grpProcedures.ResumeLayout(false);
			this.pnlProcedures.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updDeglycerolizeCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updFreezeCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updRejuvenateCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updWashCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updVolumeReduceCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updLeukoReduceCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updIrradiateCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updSplitDivideCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updThawPoolCryoCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updPoolCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updThawCost)).EndInit();
			this.pageOrderAlerts.ResumeLayout(false);
			this.grpOrderAlerts.ResumeLayout(false);
			this.grpIconAlerts.ResumeLayout(false);
			this.pnlIconAlerts.ResumeLayout(false);
			this.pnlIconOrdersNeeded.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updIconOrdersNeeded)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updRefreshRate)).EndInit();
			this.grpPrinterAlerts.ResumeLayout(false);
			this.pnlPrinterAlerts.ResumeLayout(false);
			this.pnlPrinterOrdersNeeded.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updPrinterOrdersNeeded)).EndInit();
			this.grpAlertImage.ResumeLayout(false);
			this.pageTesting.ResumeLayout(false);
			this.grpTestingImage.ResumeLayout(false);
			this.grpTestingInfo.ResumeLayout(false);
			this.pnlReactivityPhase.ResumeLayout(false);
			this.pnlServiceType.ResumeLayout(false);
			this.pnlXmatch.ResumeLayout(false);
			this.pnlAntibodyScreen.ResumeLayout(false);
			this.pageLoginMessage.ResumeLayout(false);
			this.grpLoginMessage.ResumeLayout(false);
			this.grpMessageImage.ResumeLayout(false);
			this.grpDivision.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region Methods

		/// <summary>
		/// Associate check boxes with Modification Enumeration.
		/// Implements TT_26.02
		/// </summary>
		private void SetProductModifications()
		{
			//   I didn't populate these from the database because
			// not all of the modifications are being used.
			this.cbSplit.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult);
			this.cbDeglycerolize.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Deglycerolized);
			this.cbFreeze.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Frozen);
			this.cbIrradiate.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Irradiated);
			this.cbLeukoreduce.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.LeukoReduced);
			this.cbPool.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Pooled);
			this.cbRejuvenate.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Rejuvenated);
			this.cbThaw.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Thawed);
			this.cbThawPool.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.PoolThawCryo);
			this.cbVolumeReduce.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.VolumeReduced);
			this.cbWash.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Washed);
			//
			this.updSplitDivideCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult);
			this.updDeglycerolizeCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Deglycerolized);
			this.updFreezeCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Frozen);
			this.updIrradiateCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Irradiated);
			this.updLeukoReduceCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.LeukoReduced);
			this.updPoolCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Pooled);
			this.updRejuvenateCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Rejuvenated);
			this.updThawCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Thawed);
			this.updThawPoolCryoCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.PoolThawCryo);
			this.updVolumeReduceCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.VolumeReduced);
			this.updWashCost.Tag = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Washed);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/3/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to enable electronic x-match
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns></returns>
		private bool HasAuthorityToChangeXmatch()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.EnableElectronicXMatch );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/3/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to populate ICCBBA number
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns></returns>
		private bool HasAuthorityToChangeICCBBA()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.PopulateICCBBANumber );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2004</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to configure testing
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns>Authorized indicator</returns>
		private bool HasAuthorityToConfigureTesting()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ConfigureTesting );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2004</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to configure division
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns>Authorized indicator</returns>
		private bool HasAuthorityToConfigureDivision()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ConfigureDivision );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2004</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to maintain login message
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns>Authorized indicator</returns>
		private bool HasAuthorityToMaintainLoginMessage()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.MaintainLoginMessage );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2004</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to define valie unit mods
		/// Implements BR_6.02, PT_19.01
		/// </summary>
		/// <returns>Authorized indicator</returns>
		private bool HasAuthorityToDefineUnitModifications()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.DefineValidUnitModifications );
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Private method to set public properties of user controls
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "System Configuration";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC009.DlgMaintainDivision());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.updMaxSpecimenExpiration.Maximum = Convert.ToDecimal(Common.SpecimenExpirationDays.Maximum);
			this.updMaxSpecimenExpiration.Value = Convert.ToDecimal(Common.SpecimenExpirationDays.Default);
			this.updRefreshRate.Maximum = Convert.ToDecimal(Common.OrderAlertRefreshRate.Maximum);
			this.updRefreshRate.Value = Convert.ToDecimal(Common.OrderAlertRefreshRate.Default);
			//
			this.cmbMedicalDirector.LookupEnabled = false;
			//
			if (!this.HasAuthorityToChangeICCBBA())
			{
				this.grpDivisionInfo.Enabled = false;
			}
			//
			if ((!this.HasAuthorityToConfigureTesting())&&(!this.HasAuthorityToChangeXmatch()))
			{
				this.grpTestingInfo.Enabled = false;
			}
			else if (!this.HasAuthorityToChangeXmatch())
			{
				this.rdoXmatchEnabled.Enabled = false;
				this.rdoXmatchDisabled.Enabled = false;
			}
			else if (!this.HasAuthorityToConfigureTesting())
			{
				this.pnlAntibodyScreen.Enabled = false;
			}
			//
			if (!this.HasAuthorityToDefineUnitModifications())
			{
				this.grpProcedures.Enabled = false;
			}
			//
			if (!this.HasAuthorityToConfigureDivision())
			{
				this.grpOrderAlerts.Enabled = false;
			}
			//
			if (!this.HasAuthorityToMaintainLoginMessage())
			{
				this.grpLoginMessage.Enabled = false;
			}
		}

		private void SetIccbbaLabelText()
		{
			if (this._division.BloodProductModifications.IsProductModificationEnabled)
			{
				this.lblICCBBARegNo.Text = "ICCBBA Registration No.*";
			}
			else
			{
				this.lblICCBBARegNo.Text = "ICCBBA Registration No.";
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Private method to initiliaze form controls with initial division properties
		/// </summary>
		private void PopulateForm()
		{
			this.txtCode.Text = this._division.DivisionCode;
			this.txtName.Text = this._division.DivisionName;
			this.updMaxSpecimenExpiration.Value = Convert.ToDecimal(this._division.MaximumSpecimenExpirationDays);
			SetServiceType(this._division.ServiceTypeIndicator);
			//
			//BR_9.06
			if (!this._division.ServiceTypeIndicator)
			{
				SetElectronicCrossmatch(false);
				this.rdoXmatchDisabled.Enabled = false;
				this.rdoXmatchEnabled.Enabled = false;
				this.rdoAllPhases.Enabled = false;
				this.rdoAHGOnly.Enabled = false;
			}
			else
			{
				SetElectronicCrossmatch(this._division.ElectronicCrossmatchIndicator);
			}
			SetAntibodyScreen();
			//
			SetReactivityPhaseCode(this._division.ReactivityPhaseCode);
			//
			this.txtICCBBARegNo.Text = this._division.IccbbaRegistrationNumber;
			//
			this.SetCheckBoxes();
			this.cmbMedicalDirector.Text = this._division.MedicalDirectorName;
			this.SetModificationCosts();
			//
			this.PopulateMedicalDirectors();
			//
			this.LoadPrinters();
			this.LoadAlertTypes();
			//
			this.LoadAlertsTab();
			this.LoadLoginMessageTab();
			//
			this.SetIccbbaLabelText();
			//
			this.SetToolTips();
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.txtICCBBARegNo, Common.StrRes.Tooltips.UC009.IccbaRegistrationNumber());
			this.SetThisToolTip(this.cmbMedicalDirector, Common.StrRes.Tooltips.UC009.MedicalDirectorName());
			this.SetThisToolTip(this.updMaxSpecimenExpiration, Common.StrRes.Tooltips.UC009.MaximumSpecimenExpiration());
			//
			this.SetThisToolTip(this.rdoXmatchDisabled, Common.StrRes.Tooltips.UC009.CrossmatchEnabled());
			this.SetThisToolTip(this.rdoXmatchEnabled, Common.StrRes.Tooltips.UC009.CrossmatchEnabled());
			this.SetThisToolTip(this.rdoABSOnly, Common.StrRes.Tooltips.UC009.AntibodyScreen());
			this.SetThisToolTip(this.rdoABSDAT, Common.StrRes.Tooltips.UC009.AntibodyScreen());
			this.SetThisToolTip(this.rdoABSAutoControl, Common.StrRes.Tooltips.UC009.AntibodyScreen());
			//
			this.SetThisToolTip(this.cbDeglycerolize, Common.StrRes.Tooltips.UC010.EnableModification("deglycerolizing"));
			this.SetThisToolTip(this.cbFreeze, Common.StrRes.Tooltips.UC010.EnableModification("freezing"));
			this.SetThisToolTip(this.cbIrradiate, Common.StrRes.Tooltips.UC010.EnableModification("irradiation"));
			this.SetThisToolTip(this.cbLeukoreduce, Common.StrRes.Tooltips.UC010.EnableModification("leukoreduction"));
			this.SetThisToolTip(this.cbPool, Common.StrRes.Tooltips.UC010.EnableModification("pooling"));
			this.SetThisToolTip(this.cbRejuvenate, Common.StrRes.Tooltips.UC010.EnableModification("rejuvenation"));
			this.SetThisToolTip(this.cbSplit, Common.StrRes.Tooltips.UC010.EnableModification("splitting"));
			this.SetThisToolTip(this.cbThaw, Common.StrRes.Tooltips.UC010.EnableModification("thawing"));
			this.SetThisToolTip(this.cbThawPool, Common.StrRes.Tooltips.UC010.EnableModification("thawing/pooling"));
			this.SetThisToolTip(this.cbVolumeReduce, Common.StrRes.Tooltips.UC010.EnableModification("volume reduction"));
			this.SetThisToolTip(this.cbWash, Common.StrRes.Tooltips.UC010.EnableModification("washing"));
			//
			this.SetThisToolTip(this.updDeglycerolizeCost, Common.StrRes.Tooltips.UC010.ModificationCost("deglycerolizing"));
			this.SetThisToolTip(this.updFreezeCost, Common.StrRes.Tooltips.UC010.ModificationCost("freezing"));
			this.SetThisToolTip(this.updIrradiateCost, Common.StrRes.Tooltips.UC010.ModificationCost("irradiation"));
			this.SetThisToolTip(this.updLeukoReduceCost, Common.StrRes.Tooltips.UC010.ModificationCost("leukoreduction"));
			this.SetThisToolTip(this.updPoolCost, Common.StrRes.Tooltips.UC010.ModificationCost("pooling"));
			this.SetThisToolTip(this.updRejuvenateCost, Common.StrRes.Tooltips.UC010.ModificationCost("rejuvenation"));
			this.SetThisToolTip(this.updSplitDivideCost, Common.StrRes.Tooltips.UC010.ModificationCost("splitting"));
			this.SetThisToolTip(this.updThawCost, Common.StrRes.Tooltips.UC010.ModificationCost("thawing"));
			this.SetThisToolTip(this.updThawPoolCryoCost, Common.StrRes.Tooltips.UC010.ModificationCost("thawing/pooling"));
			this.SetThisToolTip(this.updVolumeReduceCost, Common.StrRes.Tooltips.UC010.ModificationCost("volume reduction"));
			this.SetThisToolTip(this.updWashCost, Common.StrRes.Tooltips.UC010.ModificationCost("washing"));
			//
			this.SetThisToolTip(this.cbPrinterAlerts, Common.StrRes.Tooltips.UC095.PrinterAlerts());
			this.SetThisToolTip(this.cmbPrinterName, Common.StrRes.Tooltips.Common.PrinterName("new order information"));
			this.SetThisToolTip(this.cmbPrinterAlertType, Common.StrRes.Tooltips.UC095.OrderAlertType());
			this.SetThisToolTip(this.updPrinterOrdersNeeded, Common.StrRes.Tooltips.UC095.OrdersNeededIn());
			//
			this.SetThisToolTip(this.cbIconAlerts, Common.StrRes.Tooltips.UC095.IconAlerts());
			this.SetThisToolTip(this.updRefreshRate, Common.StrRes.Tooltips.UC095.RefreshRate());
			this.SetThisToolTip(this.cmbIconAlertType, Common.StrRes.Tooltips.UC095.OrderAlertType());
			this.SetThisToolTip(this.updIconOrdersNeeded, Common.StrRes.Tooltips.UC095.OrdersNeededIn());
			//
			this.SetThisToolTip(this.rtxtLoginMessage, Common.StrRes.Tooltips.UC095.LoginMessage());
			this.SetThisToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearEntries());
			//
			this.SetThisToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel());
		}

		private void PopulateMedicalDirectors()
		{
			//
			this.cmbMedicalDirector.Items.Clear();
			//
			this._medicalDirectors = BOL.Division.GetMedicalDirectors();
			//
			foreach(string director in this._medicalDirectors)
			{
				this.cmbMedicalDirector.Items.Add(director);
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/8/2003</CreationDate>
		/// <summary>
		/// Sets Antibody Screen values from division object
		/// </summary>
		private void SetAntibodyScreen()
		{
			switch (this._division.PatientTestingConfiguration)
			{
				case Common.PatientTestingConfiguration.AntibodyOnly:
					this.rdoABSOnly.Checked = true;
					break;
				case Common.PatientTestingConfiguration.AntibodyDAT:
					this.rdoABSDAT.Checked = true;						
					break;

				case Common.PatientTestingConfiguration.AntibodyAutocontrol:
					this.rdoABSAutoControl.Checked = true;				
					break;

				default:
					break;
			}
			//
			if (!this._division.ServiceTypeIndicator)
			{
				this.rdoABSOnly.Enabled = false;
				this.rdoABSDAT.Enabled = false;
				this.rdoABSAutoControl.Enabled = false;
			}
		}

		/// <summary>
		/// Sets checkboxes to true or false depending on previously selected values from the database.
		/// </summary>
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///
		private void SetCheckBoxes()
		{
			Hashtable modification = this._division.BloodProductModifications.ProductModifications;
							
			// Doing the operation below in one step (instead of two) produces wonky results!
			bool split = (bool) modification[(char) this.cbSplit.Tag];
			bool freeze = (bool) modification[(char) this.cbFreeze.Tag];
			bool deglycerolize = (bool) modification[(char) this.cbDeglycerolize.Tag];
			bool irradiate = (bool) modification[(char) this.cbIrradiate.Tag];
			bool leukoreduce = (bool) modification[(char) this.cbLeukoreduce.Tag];
			bool pool = (bool) modification[(char) this.cbPool.Tag];
			bool rejuvenate = (bool) modification[(char) this.cbRejuvenate.Tag];
			bool thaw = (bool) modification[(char) this.cbThaw.Tag];
			bool thawPool = (bool) modification[(char) this.cbThawPool.Tag];
			bool volumeReduce = (bool) modification[(char) this.cbVolumeReduce.Tag];
			bool wash = (bool) modification[(char) this.cbWash.Tag];

			this.cbSplit.Checked = split;
			this.cbFreeze.Checked = freeze;
			this.cbDeglycerolize.Checked = deglycerolize;
			this.cbIrradiate.Checked = irradiate;
			this.cbLeukoreduce.Checked = leukoreduce;
			this.cbPool.Checked = pool;
			this.cbRejuvenate.Checked = rejuvenate;
			this.cbThaw.Checked = thaw;
			this.cbThawPool.Checked = thawPool;
			this.cbVolumeReduce.Checked = volumeReduce;
			this.cbWash.Checked = wash;
		}

		private void SetModificationCosts()
		{
			Hashtable modificationCost = this._division.BloodProductModifications.ModificationCosts;
			//
			decimal splitDivideCost = (decimal)modificationCost[(char)this.updSplitDivideCost.Tag];
			decimal freezeCost = (decimal)modificationCost[(char)this.updFreezeCost.Tag];
			decimal deglycerolizeCost = (decimal)modificationCost[(char)this.updDeglycerolizeCost.Tag];
			decimal irradiateCost = (decimal)modificationCost[(char)this.updIrradiateCost.Tag];
			decimal leukoReduceCost = (decimal)modificationCost[(char)this.updLeukoReduceCost.Tag];
			decimal poolCost = (decimal)modificationCost[(char)this.updPoolCost.Tag];
			decimal rejuvenateCost = (decimal)modificationCost[(char)this.updRejuvenateCost.Tag];
			decimal thawCost = (decimal)modificationCost[(char)this.updThawCost.Tag];
			decimal thawPoolCryoCost = (decimal)modificationCost[(char)this.updThawPoolCryoCost.Tag];
			decimal volumeReduceCost = (decimal)modificationCost[(char)this.updVolumeReduceCost.Tag];
			decimal washCost = (decimal)modificationCost[(char)this.updWashCost.Tag];

			this.updSplitDivideCost.Value = splitDivideCost;
			this.updFreezeCost.Value = freezeCost;
			this.updDeglycerolizeCost.Value = deglycerolizeCost;
			this.updIrradiateCost.Value = irradiateCost;
			this.updLeukoReduceCost.Value = leukoReduceCost;
			this.updPoolCost.Value = poolCost;
			this.updRejuvenateCost.Value = rejuvenateCost;
			this.updThawCost.Value = thawCost;
			this.updThawPoolCryoCost.Value = thawPoolCryoCost;
			this.updVolumeReduceCost.Value = volumeReduceCost;
			this.updWashCost.Value = washCost;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Private method to display ElectronicCrossmatchIndicator value on form
		/// </summary>
		/// <param name="enabled">Electronic Crossmatch Enabled?</param>
		private void SetElectronicCrossmatch(bool enabled)
		{
			this.rdoXmatchEnabled.Checked = enabled;
			this.rdoXmatchDisabled.Checked = !enabled;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Private method to display ServiceTypeIndicator value on form
		/// </summary>
		/// <param name="fullService">Full Service?</param>
		private void SetServiceType(bool fullService)
		{
			//BR_9.01
			if (fullService)
			{
				this.txtServiceType.Text = "Full-Service Facility";
			}
			else
			{
				this.txtServiceType.Text = "Transfusion-Only Facility";
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/18/2003</CreationDate>
		///
		/// <summary>
		/// Set the ICCBBA reg no to upper case and validate against defined regex.
		/// </summary>
		private void ValidateICCBBARegNo()
		{
			this.txtICCBBARegNo.Text = this.txtICCBBARegNo.Text.Trim().ToUpper();
			//
			System.Text.RegularExpressions.Regex regexICCBBA = Common.RegularExpressions.IccbbaRegistrationNumber();
			if ((this.txtICCBBARegNo.Text.Length==0) || (regexICCBBA.IsMatch(this.txtICCBBARegNo.Text)))
			{
				this._division.IccbbaRegistrationNumber = this.txtICCBBARegNo.Text;
			}
			else
			{
				throw new Exception(Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod("ICCBBA Registration Number", "Enter country code character followed by four digits").ResString);
			}
		}
        
		/// <summary>
		/// Sets the initial value of ReactivityPhase
		/// </summary>
		/// <param name="code"></param>
		private void SetReactivityPhaseCode(Common.ReactivityPhase code)
		{
			if (code == Common.ReactivityPhase.All)
			{
				this.rdoAllPhases.Checked = true;
				this.rdoAHGOnly.Checked = false;
			}
			else
			{
				this.rdoAllPhases.Checked = false;
				this.rdoAHGOnly.Checked = true;
			}
		}

		///<Developers>					   
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/12/2003</CreationDate>
		/// <summary>
		/// Enables/disabled cost UI controls, based on associated checkbox
		/// </summary>
		private void EnableCostControls()
		{
			this.updDeglycerolizeCost.Enabled = this.cbDeglycerolize.Checked;
			this.updFreezeCost.Enabled = this.cbFreeze.Checked;
			this.updIrradiateCost.Enabled = this.cbIrradiate.Checked;
			this.updLeukoReduceCost.Enabled = this.cbLeukoreduce.Checked;
			this.updPoolCost.Enabled = this.cbPool.Checked;
			this.updRejuvenateCost.Enabled = this.cbRejuvenate.Checked;
			this.updSplitDivideCost.Enabled = this.cbSplit.Checked;
			this.updThawCost.Enabled = this.cbThaw.Checked;
			this.updThawPoolCryoCost.Enabled = this.cbThawPool.Checked;
			this.updVolumeReduceCost.Enabled = this.cbVolumeReduce.Checked;
			this.updWashCost.Enabled = this.cbWash.Checked;
			//
			//Update the error providers
			this.CostLeave(this,EventArgs.Empty);
		}

		#endregion


		#region Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Private event handler to update ElectronicCrossmatchIndicator after changed on form
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// 
		private void ElectronicCrossmatchIndicatorChanged(object sender, System.EventArgs e)
		{
			try
			{
				this._division.ElectronicCrossmatchIndicator = this.rdoXmatchEnabled.Checked;
				this.errError.SetVbecsError(this.rdoXmatchEnabled, ""); // **** 508 Compliance ***
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.rdoXmatchEnabled, err.Message); // **** 508 Compliance ***
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoXmatchEnabled, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Called whenever a checkbox is checked/ unchecked.
		/// </summary>
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///
		private void CheckedChanged(object sender, System.EventArgs e)
		{
			Hashtable modification = this._division.BloodProductModifications.ProductModifications;
			//
			modification[(char) this.cbSplit.Tag] = this.cbSplit.Checked;
			//
			#region Split/Divide - Pediatric: Future Use Only
			//
			//	At this time we are only updating adults, so the following may be added in the future:
			//
			//				Although there are actually two splits (adult 'S' and pediatric 'C'), only one is
			//				displayed to the user.  However, both must be updated in the database.
			//				modification['C'] = this.cbSplit.Checked;
			//
			#endregion
			//
			modification[(char) this.cbDeglycerolize.Tag] = this.cbDeglycerolize.Checked;
			modification[(char) this.cbFreeze.Tag] = this.cbFreeze.Checked;
			modification[(char) this.cbIrradiate.Tag] = this.cbIrradiate.Checked;
			modification[(char) this.cbLeukoreduce.Tag] = this.cbLeukoreduce.Checked;
			modification[(char) this.cbPool.Tag] = this.cbPool.Checked;
			modification[(char) this.cbRejuvenate.Tag] = this.cbRejuvenate.Checked;
			modification[(char) this.cbThaw.Tag] = this.cbThaw.Checked;
			modification[(char) this.cbThawPool.Tag] = this.cbThawPool.Checked;
			modification[(char) this.cbVolumeReduce.Tag] = this.cbVolumeReduce.Checked;
			modification[(char) this.cbWash.Tag] = this.cbWash.Checked;
			//
			// Reset to ensure broken rules updated
			this._division.IccbbaRegistrationNumber = this._division.IccbbaRegistrationNumber;
			//
			SetIccbbaLabelText();
			//
			EnableCostControls();
			//
			if (!this._loadingDetails)
			{
				this._division.IsDirty = true;
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// Cost changed event handler. Called whenever a value changes in a numeric up/down control.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CostChanged(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//
				Hashtable modificationCosts = this._division.BloodProductModifications.ModificationCosts;
				//
				try
				{
					// Although there are actually two splits (adult 'S' and pediatric 'C'), only one is
					// displayed to the user.  However, both must be updated in the database.
					modificationCosts['C'] = this.updSplitDivideCost.Value;
					modificationCosts[(char) this.updSplitDivideCost.Tag] = this.updSplitDivideCost.Value;
					this.errError.SetVbecsError(updSplitDivideCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts['C'] = decimal.MinusOne;
					modificationCosts[(char) this.updSplitDivideCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updDeglycerolizeCost.Tag] = this.updDeglycerolizeCost.Value;
					this.errError.SetVbecsError(updDeglycerolizeCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updDeglycerolizeCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updFreezeCost.Tag] = this.updFreezeCost.Value;
					this.errError.SetVbecsError(updFreezeCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updFreezeCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updIrradiateCost.Tag] = this.updIrradiateCost.Value;
					this.errError.SetVbecsError(updIrradiateCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updIrradiateCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updLeukoReduceCost.Tag] = this.updLeukoReduceCost.Value;
					this.errError.SetVbecsError(updLeukoReduceCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updLeukoReduceCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updPoolCost.Tag] = this.updPoolCost.Value;
					this.errError.SetVbecsError(updPoolCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updPoolCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updRejuvenateCost.Tag] = this.updRejuvenateCost.Value;
					this.errError.SetVbecsError(updRejuvenateCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updRejuvenateCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updThawCost.Tag] = this.updThawCost.Value;
					this.errError.SetVbecsError(updThawCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updThawCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updThawPoolCryoCost.Tag] = this.updThawPoolCryoCost.Value;
					this.errError.SetVbecsError(updThawPoolCryoCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updThawPoolCryoCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updVolumeReduceCost.Tag] = this.updVolumeReduceCost.Value;
					this.errError.SetVbecsError(updVolumeReduceCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updVolumeReduceCost.Tag] = decimal.MinusOne;
				}
				try
				{
					modificationCosts[(char) this.updWashCost.Tag] = this.updWashCost.Value;
					this.errError.SetVbecsError(updWashCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					modificationCosts[(char) this.updWashCost.Tag] = decimal.MinusOne;
				}

			//
				this._division.IsDirty = true;
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// Cost changed event handler. Called whenever a value changes in a numeric up/down control.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CostLeave(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//
				Hashtable modificationCosts = this._division.BloodProductModifications.ModificationCosts;
				Hashtable modification = this._division.BloodProductModifications.ProductModifications;
				//
				try
				{
					// Although there are actually two splits (adult 'S' and pediatric 'C'), only one is
					// displayed to the user.  However, both must be updated in the database.
					modificationCosts['C'] = this.updSplitDivideCost.Value;
					modificationCosts[(char) this.updSplitDivideCost.Tag] = this.updSplitDivideCost.Value;
					this.errError.SetVbecsError(updSplitDivideCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts['C'] = decimal.MinusOne;
					modificationCosts[(char) this.updSplitDivideCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updSplitDivideCost.Tag])
						this.errError.SetVbecsError(updSplitDivideCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updSplitDivideCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updDeglycerolizeCost.Tag] = this.updDeglycerolizeCost.Value;
					this.errError.SetVbecsError(updDeglycerolizeCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updDeglycerolizeCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updDeglycerolizeCost.Tag])
						this.errError.SetVbecsError(updDeglycerolizeCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updDeglycerolizeCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updFreezeCost.Tag] = this.updFreezeCost.Value;
					this.errError.SetVbecsError(updFreezeCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updFreezeCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updFreezeCost.Tag])
						this.errError.SetVbecsError(updFreezeCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updFreezeCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updIrradiateCost.Tag] = this.updIrradiateCost.Value;
					this.errError.SetVbecsError(updIrradiateCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updIrradiateCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updIrradiateCost.Tag])
						this.errError.SetVbecsError(updIrradiateCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updIrradiateCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updLeukoReduceCost.Tag] = this.updLeukoReduceCost.Value;
					this.errError.SetVbecsError(updLeukoReduceCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updLeukoReduceCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updLeukoReduceCost.Tag])
						this.errError.SetVbecsError(updLeukoReduceCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updLeukoReduceCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updPoolCost.Tag] = this.updPoolCost.Value;
					this.errError.SetVbecsError(updPoolCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updPoolCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updPoolCost.Tag])
						this.errError.SetVbecsError(updPoolCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updPoolCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updRejuvenateCost.Tag] = this.updRejuvenateCost.Value;
					this.errError.SetVbecsError(updRejuvenateCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updRejuvenateCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updRejuvenateCost.Tag])
						this.errError.SetVbecsError(updRejuvenateCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updRejuvenateCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updThawCost.Tag] = this.updThawCost.Value;
					this.errError.SetVbecsError(updThawCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updThawCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updThawCost.Tag])
						this.errError.SetVbecsError(updThawCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updThawCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updThawPoolCryoCost.Tag] = this.updThawPoolCryoCost.Value;
					this.errError.SetVbecsError(updThawPoolCryoCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updThawPoolCryoCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updThawPoolCryoCost.Tag])
						this.errError.SetVbecsError(updThawPoolCryoCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updThawPoolCryoCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updVolumeReduceCost.Tag] = this.updVolumeReduceCost.Value;
					this.errError.SetVbecsError(updVolumeReduceCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updVolumeReduceCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updVolumeReduceCost.Tag])
						this.errError.SetVbecsError(updVolumeReduceCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updVolumeReduceCost, string.Empty); // **** 508 Compliance ***
				}
				try
				{
					modificationCosts[(char) this.updWashCost.Tag] = this.updWashCost.Value;
					this.errError.SetVbecsError(updWashCost, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					modificationCosts[(char) this.updWashCost.Tag] = decimal.MinusOne;
					if ((bool)modification[(char) this.updWashCost.Tag])
						this.errError.SetVbecsError(updWashCost, err.Message); // **** 508 Compliance ***
					else
						this.errError.SetVbecsError(updWashCost, string.Empty); // **** 508 Compliance ***
				}
				//
				this._division.IsDirty = true;
				this.CheckValid(sender,e);
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// Broken Rules and IsDirty event handler.
		/// Checks if division is valid.
		/// Enable/Disable Save button.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			btnOK.EnabledButton = (_division.IsValid && _division.DivisionAlerts.IsValid && (this.errError.GetError(this.txtICCBBARegNo).Length==0) //_medicalDirector.IsValid &&
				&& CheckModificationCostsValid() && (_division.IsDirty || _division.DivisionAlerts.IsDirty));  //_medicalDirector.IsDirty || 
		}

		private bool CheckModificationCostsValid()
		{
			Hashtable modification = this._division.BloodProductModifications.ProductModifications;
			//
			IDictionaryEnumerator myEnumerator = this._division.BloodProductModifications.ModificationCosts.GetEnumerator();
			while ( myEnumerator.MoveNext() )
			{
				if (Convert.ToDecimal(myEnumerator.Value) == decimal.MinusOne)
				{
					if ((bool)modification[(char)myEnumerator.Key])
					{
						return false;
					}
				}
			}
			return true;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/30/2002</CreationDate>
		///
		/// <summary>
		/// OK Button Click event. Prompts user to save division.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("division") ) != DialogResult.Yes)
				return;
		
			try
			{
				if (!this._division.Save(Common.UpdateFunction.UC009DlgMaintainDivision))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("VAMC division"));
					return;
				}
				if (!this._division.BloodProductModifications.UpdateProductModifications(LogonUser.LogonUserDivisionCode, Common.UpdateFunction.UC009DlgMaintainDivision))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Product modification configuration"));
					return;
				}
				//		
				ThisUser.LogonToDivision( LogonUser.LogonUserDivisionCode ); // Division information for the user needs to be updated here

                //CR3400 - refresh the icons only if they've made any changes
			    if (this._division.DivisionAlerts.IconAlertsIndicator != this._startingDivisionAlerts.IconAlertsIndicator ||
                    this._division.DivisionAlerts.IconOrderAlertType != this._startingDivisionAlerts.IconOrderAlertType ||
                    this._division.DivisionAlerts.IconOrdersNeededHours != this._startingDivisionAlerts.IconOrdersNeededHours ||
                    this._division.DivisionAlerts.IconRefreshRate != this._startingDivisionAlerts.IconRefreshRate)
			        {
			            ((FrmVbecs) this.TopLevelControl).UpdateDivisionAndAlertRefreshRate();
			        }
			}
			catch(RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
			//The data has been saved and the page is not dirty.
			this.IsDirty = false;
			this.Close();
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			System.Text.StringBuilder str = new System.Text.StringBuilder();
			//
			str.Append(this._division.GetBrokenRulesMessage(this.Name));
			str.Append(this._division.DivisionAlerts.GetBrokenRulesMessage(this.Name));
			//
			if (this.errError.GetError(this.txtICCBBARegNo).Length>0)
			{
				str.Append("\n"+this.errError.GetError(this.txtICCBBARegNo));
			}
			//
			if (!this.CheckModificationCostsValid())
			{
				str.Append("\nValid modification costs must be entered for all enabled modifications.");
			}
			//
			if (str.ToString().Length == 0)
			{
				if (!(this._division.IsDirty||this._division.DivisionAlerts.IsDirty)) //this._medicalDirector.IsDirty||
				{
					str.Append("Cannot save - division configuration has not changed");
				}
				else
				{
					str.Append("Click to save changes to division configuration");
				}
			}
			//
			btnOK.SetToolTip(str.ToString());
		}

		/*
		*************************************
		Antibody Screen Radio buttons
		************************************
		*/
		private void rdoABSOnly_CheckedChanged(object sender, System.EventArgs e)
		{
			this._division.PatientTestingConfiguration = Common.PatientTestingConfiguration.AntibodyOnly;
		}

		private void rdoABSDAT_CheckedChanged(object sender, System.EventArgs e)
		{
			this._division.PatientTestingConfiguration = Common.PatientTestingConfiguration.AntibodyDAT;
		}

		private void rdoABSAutoControl_CheckedChanged(object sender, System.EventArgs e)
		{
			this._division.PatientTestingConfiguration = Common.PatientTestingConfiguration.AntibodyAutocontrol;
		}

		private void updMaxSpecimenExpiration_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				try
				{
					this._division.MaximumSpecimenExpirationDays = Convert.ToInt16(updMaxSpecimenExpiration.Value);
					this.errError.SetVbecsError(lblDays, ""); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					this._division.MaximumSpecimenExpirationDays = 0;
				}
			}
		}

		private void updMaxSpecimenExpiration_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this._division.MaximumSpecimenExpirationDays = Convert.ToInt16(updMaxSpecimenExpiration.Value);
				this.errError.SetVbecsError(lblDays, ""); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this.errError.SetVbecsError(lblDays, err.Message); // **** 508 Compliance ***
				this._division.MaximumSpecimenExpirationDays = 0;
			}
		}

		private void DlgMaintainDivision_Load(object sender, System.EventArgs e)
		{
			
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void txtICCBBARegNo_Leave(object sender, System.EventArgs e)
		{
			try 
			{
				ValidateICCBBARegNo();
				this.errError.SetVbecsError(this.txtICCBBARegNo, ""); // **** 508 Compliance ***
			}
			catch(BOL.BusinessObjectException err)
			{
				this._division.IccbbaRegistrationNumber = "";
				this.errError.SetVbecsError(this.txtICCBBARegNo, err.Message); // **** 508 Compliance ***
			}
			catch(Exception)
			{
				this._division.IccbbaRegistrationNumber = "";
				errError.SetVbecsError(this.txtICCBBARegNo, Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod("ICCBBA Registration Number", "Enter country code character followed by four digits").ResString); // **** 508 Compliance ***
			}
			//
			this.CheckValid(sender,e);
		}

		private void txtICCBBARegNo_TextChanged(object sender, System.EventArgs e)
		{
			if ((this.txtICCBBARegNo.Text.Trim().Length == 0) || (this.txtICCBBARegNo.Text.Trim().Length == 5))
			{
				this.txtICCBBARegNo_Leave(sender,e);
			}
		}

		private void cmbMedicalDirector_TextChanged(object sender, System.EventArgs e)
		{
			this._division.MedicalDirectorName = this.cmbMedicalDirector.Text;
		}

		#endregion

		#region UC_95 Methods

		/// <summary>
		/// Loads printer names into combo box.
		/// </summary>
		private void LoadPrinters()
		{
			foreach (string printerName in BOL.DivisionAlerts.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		/// <summary>
		/// Loads alert types into combo boxes.
		/// </summary>
		private void LoadAlertTypes()
		{
			_alertTypes = BOL.DivisionAlerts.GetOrderAlertTypeList();
			//
			foreach (System.Data.DataRow dr in _alertTypes.Rows)
			{
				cmbPrinterAlertType.Items.Add(dr[Common.VbecsTables.OrderAlertType.OrderAlertTypeText].ToString());
				cmbIconAlertType.Items.Add(dr[Common.VbecsTables.OrderAlertType.OrderAlertTypeText].ToString());
			}
		}

		/// <summary>
		/// Returns datarow index of an alert type.
		/// </summary>
		/// <param name="alertType">Alert Type</param>
		/// <returns>Data row index</returns>
		private int GetAlertTypeIndex(Common.OrderAlertTypeCode alertType)
		{
			for (int i = 0; i < _alertTypes.Rows.Count ; i++)
			{
				if (_alertTypes.Rows[i][Common.VbecsTables.OrderAlertType.OrderAlertTypeCode].ToString() == Common.Utility.GetOrderAlertTypeTypeFromEnum(alertType))
				{
					return i;
				}
			}
			return -1;
		}

		/// <summary>
		/// Load login message from database.
		/// </summary>
		private void LoadLoginMessageTab()
		{
			this.rtxtLoginMessage.Text = this._division.DivisionAlerts.LoginMessage;
		}

		/// <summary>
		/// Load order alert settings from database.
		/// </summary>
		private void LoadAlertsTab()
		{
			this.cbPrinterAlerts.Checked = this._division.DivisionAlerts.PrintAlertsIndicator;
			if (this._division.DivisionAlerts.PrinterName != null)
			{
				this.cmbPrinterName.SelectedIndex = this.cmbPrinterName.Items.IndexOf(this._division.DivisionAlerts.PrinterName);
			}
			else
			{
				this.cmbPrinterName.SelectedIndex = -1;
			}
			this.cmbPrinterAlertType.SelectedIndex = GetAlertTypeIndex(this._division.DivisionAlerts.PrintOrderAlertType);
			if (this._division.DivisionAlerts.PrintOrderNeededHours > 0)
			{
				this.updPrinterOrdersNeeded.Value = this._division.DivisionAlerts.PrintOrderNeededHours;
			}
			else
			{
				this.updPrinterOrdersNeeded.Value = 48;
			}
			//
			this.cbIconAlerts.Checked = this._division.DivisionAlerts.IconAlertsIndicator;
			if (this._division.DivisionAlerts.IconRefreshRate > 0)
			{
				this.updRefreshRate.Value = this._division.DivisionAlerts.IconRefreshRate;
			}
			else
			{
				this.updRefreshRate.Value = 60;
			}
			this.cmbIconAlertType.SelectedIndex = GetAlertTypeIndex(this._division.DivisionAlerts.IconOrderAlertType);
			if (this._division.DivisionAlerts.IconOrdersNeededHours > 0)
			{
				this.updIconOrdersNeeded.Value = this._division.DivisionAlerts.IconOrdersNeededHours;
			}
			else
			{
				this.updIconOrdersNeeded.Value = 48;
			}

		}

		/// <summary>
		/// Clear button click event handler.
		/// Clears all text in Login Message rich text box.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			//Delete Login Message
			rtxtLoginMessage.Text = "";
		}

		/// <summary>
		/// Login Message Rich Text Box text changed event handler.
		/// Updates Login Message property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rtxtLoginMessage_TextChanged(object sender, System.EventArgs e)
		{
			//Set LoginMessage property.
			try
			{
				this._division.DivisionAlerts.LoginMessage = this.rtxtLoginMessage.Text;
				this.errError.SetVbecsError(lblLoginMessage, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.LoginMessage = "";
				this.errError.SetVbecsError(lblLoginMessage, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Login Message Rich Text Box URL clicked event handler.
		/// Opens URL in default web browser.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Link clicked event args</param>
		private void rtxtLoginMessage_LinkClicked(object sender, System.Windows.Forms.LinkClickedEventArgs e)
		{
			using (new WaitCursor())
			{
				System.Diagnostics.Process.Start(e.LinkText);
			}
		}

		/// <summary>
		/// Printer Alerts checkbox checked changed event handler.
		/// Updates Print Alerts Indicator property and
		/// shows/hides the printer alerts panel.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cbPrinterAlerts_CheckedChanged(object sender, System.EventArgs e)
		{
			//Set PrintAlertsIndicator property.
			try
			{
				this._division.DivisionAlerts.PrintAlertsIndicator = this.cbPrinterAlerts.Checked;
				this.errError.SetVbecsError(this.cbPrinterAlerts, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.cbPrinterAlerts, err.Message); // **** 508 Compliance ***
			}
			//
			//Only enable Printer Alerts panel if turned on
			this.pnlPrinterAlerts.Enabled = this._division.DivisionAlerts.PrintAlertsIndicator;
		}

		/// <summary>
		/// Icon Alerts checkbox checked changed event handler.
		/// Updates Icon Alerts Indicator property and
		/// shows/hides the icon alerts panel.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cbIconAlerts_CheckedChanged(object sender, System.EventArgs e)
		{
			//Set IconAlertsIndicator property.
			try
			{
				this._division.DivisionAlerts.IconAlertsIndicator = this.cbIconAlerts.Checked;
				this.errError.SetVbecsError(this.cbIconAlerts, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.cbIconAlerts, err.Message); // **** 508 Compliance ***
			}
			//
			//Only enable Icon Alerts panel if turned on
			this.pnlIconAlerts.Enabled = this._division.DivisionAlerts.IconAlertsIndicator;
		}

		/// <summary>
		/// Printer Name combo box selected index changed event handler.
		/// Updates Printer Name property
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//Set PrinterName property
			try
			{
				if (cmbPrinterName.SelectedIndex > -1)
				{
					this._division.DivisionAlerts.PrinterName = cmbPrinterName.SelectedItem.ToString();
				}
				else
				{
					this._division.DivisionAlerts.PrinterName = "";
				}
				this.errError.SetVbecsError(cmbPrinterName, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.PrinterName = "";
				this.errError.SetVbecsError(cmbPrinterName, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Printer Alert Type combo box selected index changed event handler.
		/// Updates Printer Order Alert Type property and
		/// shows/hides the Printer Orders Needed panel.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbPrinterAlertType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//Set PrintOrderAlertType property
			try
			{
				if (cmbPrinterAlertType.SelectedIndex > -1)
				{
					this._division.DivisionAlerts.PrintOrderAlertType = Common.Utility.GetOrderAlertTypeTypeFromString(_alertTypes.Rows[cmbPrinterAlertType.SelectedIndex]["OrderAlertTypeCode"].ToString());
				}
				else
				{
					this._division.DivisionAlerts.PrintOrderAlertType = Common.OrderAlertTypeCode.Unknown;
				}
				this.errError.SetVbecsError(cmbPrinterAlertType, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.PrintOrderAlertType = Common.OrderAlertTypeCode.Unknown;
				this.errError.SetVbecsError(cmbPrinterAlertType, err.Message); // **** 508 Compliance ***
			}
			//
			//Only Display Hours panel if Hour Limit Order type selected
			this.pnlPrinterOrdersNeeded.Visible = (this._division.DivisionAlerts.PrintOrderAlertType == Common.OrderAlertTypeCode.Hour_limit);
		}

		/// <summary>
		/// Icon Alert Type combo box selected index changed event handler.
		/// Updates Icon Order Alert Type property and
		/// shows/hides the Icon Orders Needed panel.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbIconAlertType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//Set IconOrderAlertType property
			try
			{
				if (cmbIconAlertType.SelectedIndex > -1)
				{
					this._division.DivisionAlerts.IconOrderAlertType = Common.Utility.GetOrderAlertTypeTypeFromString(_alertTypes.Rows[cmbIconAlertType.SelectedIndex]["OrderAlertTypeCode"].ToString());
				}
				else
				{
					this._division.DivisionAlerts.IconOrderAlertType = Common.OrderAlertTypeCode.Unknown;
				}
				this.errError.SetVbecsError(cmbIconAlertType, ""); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.IconOrderAlertType = Common.OrderAlertTypeCode.Unknown;
				this.errError.SetVbecsError(cmbIconAlertType, err.Message); // **** 508 Compliance ***
			}
			//
			//Only Display Hours panel if Hour Limit Order type selected
			this.pnlIconOrdersNeeded.Visible = (this._division.DivisionAlerts.IconOrderAlertType == Common.OrderAlertTypeCode.Hour_limit);		
		}

		/// <summary>
		/// Printer Orders Needed up/down control value changed event handler.
		/// Updates the Print Order Needed Hours property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void updPrinterOrdersNeeded_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//Set PrintOrderNeededHours property
				try
				{
					this._division.DivisionAlerts.PrintOrderNeededHours = Convert.ToInt32(this.updPrinterOrdersNeeded.Value);
					this.errError.SetVbecsError(this.lblPrinterHours, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					this._division.DivisionAlerts.PrintOrderNeededHours = 0;
				}
				catch (BOL.BusinessObjectException err)
				{
					this._division.DivisionAlerts.PrintOrderNeededHours = 0;
					this.errError.SetVbecsError(this.lblPrinterHours, err.Message); // **** 508 Compliance ***
				}
			}
		}

		/// <summary>
		/// Printer Orders Needed up/down control leave event handler.
		/// Updates the Print Order Needed Hours property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void updPrinterOrdersNeeded_Leave(object sender, System.EventArgs e)
		{
			//Set PrintOrderNeededHours property
			try
			{
				this._division.DivisionAlerts.PrintOrderNeededHours = Convert.ToInt32(this.updPrinterOrdersNeeded.Value);
				this.errError.SetVbecsError(this.lblPrinterHours, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this._division.DivisionAlerts.PrintOrderNeededHours = 0;
				if (this._division.DivisionAlerts.PrintOrderAlertType == Common.OrderAlertTypeCode.Hour_limit)
				{
					this.errError.SetVbecsError(this.lblPrinterHours, err.Message); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.lblPrinterHours, string.Empty); // **** 508 Compliance ***
				}
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.PrintOrderNeededHours = 0;
				this.errError.SetVbecsError(this.lblPrinterHours, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Refresh Rate up/down control value changed event and leave handler.
		/// Updates the Icon Refresh Rate property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void updRefreshRate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//Set IconRefreshRate property
				try
				{
					this._division.DivisionAlerts.IconRefreshRate = Convert.ToInt32(this.updRefreshRate.Value);
					this.errError.SetVbecsError(this.lblSeconds, string.Empty); // **** 508 Compliance ***
				}
				catch (FormatException)
				{
					this._division.DivisionAlerts.IconRefreshRate = 0;
				}
				catch (BOL.BusinessObjectException err)
				{
					this._division.DivisionAlerts.IconRefreshRate = 0;
					this.errError.SetVbecsError(this.lblSeconds, err.Message); // **** 508 Compliance ***
				}
			}
		}

		private void updRefreshRate_Leave(object sender, System.EventArgs e)
		{
			//Set IconRefreshRate property
			try
			{
				this._division.DivisionAlerts.IconRefreshRate = Convert.ToInt32(this.updRefreshRate.Value);
				this.errError.SetVbecsError(this.lblSeconds, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this._division.DivisionAlerts.IconRefreshRate = 0;
				if (this._division.DivisionAlerts.IconAlertsIndicator)
				{
					this.errError.SetVbecsError(this.lblSeconds, err.Message); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.lblSeconds, string.Empty); // **** 508 Compliance ***
				}
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.IconRefreshRate = 0;
				this.errError.SetVbecsError(this.lblSeconds, err.Message); // **** 508 Compliance ***
			}		
		}

		/// <summary>
		/// Icon Orders Needed up/down control value changed event handler.
		/// Updates the Icon Order Needed Hours property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void updIconOrdersNeeded_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//Set IconOrderNeededHours property
				try
				{
					this._division.DivisionAlerts.IconOrdersNeededHours = Convert.ToInt32(this.updIconOrdersNeeded.Value);
					this.errError.SetVbecsError(this.lblIconHours, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					this._division.DivisionAlerts.IconOrdersNeededHours = 0;
				}
				catch (BOL.BusinessObjectException err)
				{
					this._division.DivisionAlerts.IconOrdersNeededHours = 0;
					this.errError.SetVbecsError(this.lblIconHours, err.Message); // **** 508 Compliance ***
				}		
			}
		}

		/// <summary>
		/// Icon Orders Needed up/down control leave event handler.
		/// Updates the Icon Order Needed Hours property.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void updIconOrdersNeeded_Leave(object sender, System.EventArgs e)
		{
			//Set IconOrderNeededHours property
			try
			{
				this._division.DivisionAlerts.IconOrdersNeededHours = Convert.ToInt32(this.updIconOrdersNeeded.Value);
				this.errError.SetVbecsError(this.lblIconHours, string.Empty); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				this._division.DivisionAlerts.IconOrdersNeededHours = 0;
				if (this._division.DivisionAlerts.IconOrderAlertType == Common.OrderAlertTypeCode.Hour_limit)
				{
					this.errError.SetVbecsError(this.lblIconHours, err.Message); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.lblIconHours, string.Empty); // **** 508 Compliance ***
				}
			}
			catch (BOL.BusinessObjectException err)
			{
				this._division.DivisionAlerts.IconOrdersNeededHours = 0;
				this.errError.SetVbecsError(this.lblIconHours, err.Message); // **** 508 Compliance ***
			}
		}

		#endregion

		private void tabOptions_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.tabOptions.SelectedTab == this.pageDivision)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC009.DlgMaintainDivision());
			}
			else if (this.tabOptions.SelectedTab == this.pageLoginMessage)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC095.DlgMaintainDivision_Login());
			}
			else if (this.tabOptions.SelectedTab == this.pageOrderAlerts)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC095.DlgMaintainDivision());
			}
			else if (this.tabOptions.SelectedTab == this.pageTesting)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC055.DlgMaintainDivision());
			}
			else if (this.tabOptions.SelectedTab == this.tabProductMods)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC010.DlgMaintainDivision());
			}
		}

		private void pnlPrinterAlerts_EnabledChanged(object sender, EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//Reset error providers
				if (pnlPrinterAlerts.Enabled)
				{
					this.updPrinterOrdersNeeded_Leave(sender,e);
				}
				else
				{
					this.errError.SetVbecsError(this.lblPrinterHours, string.Empty); // **** 508 Compliance ***
				}
			}
		}

		private void pnlIconAlerts_EnabledChanged(object sender, EventArgs e)
		{
			if (!this._loadingDetails)
			{
				//Reset error providers
				if (pnlIconAlerts.Enabled)
				{
					this.updRefreshRate_Leave(sender,e);
					this.updIconOrdersNeeded_Leave(sender,e);
				}
				else
				{
					this.errError.SetVbecsError(this.lblSeconds, string.Empty); // **** 508 Compliance ***
					this.errError.SetVbecsError(this.lblIconHours, string.Empty); // **** 508 Compliance ***
				}
			}
		}

		//CR 2717
		private void rdoAllPhases_CheckedChanged(object sender, System.EventArgs e)
		{
			this._division.ReactivityPhaseCode = Common.ReactivityPhase.All;		
		}

		//CR 2717
		private void rdoAHGOnly_CheckedChanged(object sender, System.EventArgs e)
		{
			this._division.ReactivityPhaseCode = Common.ReactivityPhase.AHGandCC;
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgMaintainDivision_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnOK.GetToolTip();
			}

			//
			this.SpeakMessage( textToSpeak );
		}


	}
}

